/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.dialogs;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.app.Activity;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.RelativeLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import com.kongzue.dialogx.DialogX;
import com.kongzue.dialogx.R;
import com.kongzue.dialogx.interfaces.BaseDialog;
import com.kongzue.dialogx.interfaces.DialogConvertViewInterface;
import com.kongzue.dialogx.interfaces.DialogLifecycleCallback;
import com.kongzue.dialogx.interfaces.DialogXStyle;
import com.kongzue.dialogx.interfaces.OnBackPressedListener;
import com.kongzue.dialogx.interfaces.OnBindView;
import com.kongzue.dialogx.interfaces.OnSafeInsetsChangeListener;
import com.kongzue.dialogx.util.FullScreenDialogTouchEventInterceptor;
import com.kongzue.dialogx.util.views.ActivityScreenShotImageView;
import com.kongzue.dialogx.util.views.DialogXBaseRelativeLayout;
import com.kongzue.dialogx.util.views.MaxRelativeLayout;

public class FullScreenDialog
extends BaseDialog {
    public static int overrideEnterDuration = -1;
    public static int overrideExitDuration = -1;
    public static BaseDialog.BOOLEAN overrideCancelable;
    protected OnBindView<FullScreenDialog> onBindView;
    protected BaseDialog.BOOLEAN privateCancelable;
    protected DialogLifecycleCallback<FullScreenDialog> dialogLifecycleCallback;
    protected FullScreenDialog me = this;
    private View dialogView;
    protected DialogImpl dialogImpl;

    protected FullScreenDialog() {
    }

    public static FullScreenDialog build() {
        return new FullScreenDialog();
    }

    public FullScreenDialog(OnBindView<FullScreenDialog> onBindView) {
        this.onBindView = onBindView;
    }

    public static FullScreenDialog show(OnBindView<FullScreenDialog> onBindView) {
        FullScreenDialog fullScreenDialog = new FullScreenDialog(onBindView);
        fullScreenDialog.show();
        return fullScreenDialog;
    }

    public void show() {
        super.beforeShow();
        this.dialogView = this.createView(this.isLightTheme() ? R.layout.layout_dialogx_fullscreen : R.layout.layout_dialogx_fullscreen_dark);
        this.dialogImpl = new DialogImpl(this.dialogView);
        if (this.dialogView != null) {
            this.dialogView.setTag((Object)this.me);
        }
        FullScreenDialog.show(this.dialogView);
    }

    public void show(Activity activity) {
        super.beforeShow();
        this.dialogView = this.createView(this.isLightTheme() ? R.layout.layout_dialogx_fullscreen : R.layout.layout_dialogx_fullscreen_dark);
        this.dialogImpl = new DialogImpl(this.dialogView);
        if (this.dialogView != null) {
            this.dialogView.setTag((Object)this.me);
        }
        FullScreenDialog.show(activity, this.dialogView);
    }

    @Override
    public String dialogKey() {
        return this.getClass().getSimpleName() + "(" + Integer.toHexString(this.hashCode()) + ")";
    }

    public void refreshUI() {
        FullScreenDialog.runOnMain(new Runnable(){

            @Override
            public void run() {
                if (FullScreenDialog.this.dialogImpl != null) {
                    FullScreenDialog.this.dialogImpl.refreshView();
                }
            }
        });
    }

    public void dismiss() {
        if (this.dialogImpl == null) {
            return;
        }
        this.dialogImpl.doDismiss(null);
    }

    public DialogLifecycleCallback<FullScreenDialog> getDialogLifecycleCallback() {
        return this.dialogLifecycleCallback == null ? new DialogLifecycleCallback<FullScreenDialog>(){} : this.dialogLifecycleCallback;
    }

    public FullScreenDialog setDialogLifecycleCallback(DialogLifecycleCallback<FullScreenDialog> dialogLifecycleCallback) {
        this.dialogLifecycleCallback = dialogLifecycleCallback;
        if (this.isShow) {
            dialogLifecycleCallback.onShow(this.me);
        }
        return this;
    }

    public OnBackPressedListener getOnBackPressedListener() {
        return this.onBackPressedListener;
    }

    public FullScreenDialog setOnBackPressedListener(OnBackPressedListener onBackPressedListener) {
        this.onBackPressedListener = onBackPressedListener;
        this.refreshUI();
        return this;
    }

    public FullScreenDialog setStyle(DialogXStyle style) {
        this.style = style;
        return this;
    }

    public FullScreenDialog setTheme(DialogX.THEME theme) {
        this.theme = theme;
        return this;
    }

    @Override
    public boolean isCancelable() {
        if (this.privateCancelable != null) {
            return this.privateCancelable == BaseDialog.BOOLEAN.TRUE;
        }
        if (overrideCancelable != null) {
            return overrideCancelable == BaseDialog.BOOLEAN.TRUE;
        }
        return this.cancelable;
    }

    public FullScreenDialog setCancelable(boolean cancelable) {
        this.privateCancelable = cancelable ? BaseDialog.BOOLEAN.TRUE : BaseDialog.BOOLEAN.FALSE;
        this.refreshUI();
        return this;
    }

    public DialogImpl getDialogImpl() {
        return this.dialogImpl;
    }

    public FullScreenDialog setCustomView(OnBindView<FullScreenDialog> onBindView) {
        this.onBindView = onBindView;
        this.refreshUI();
        return this;
    }

    public View getCustomView() {
        if (this.onBindView == null) {
            return null;
        }
        return this.onBindView.getCustomView();
    }

    public FullScreenDialog removeCustomView() {
        this.onBindView.clean();
        this.refreshUI();
        return this;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public FullScreenDialog setBackgroundColor(@ColorInt int backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.refreshUI();
        return this;
    }

    public FullScreenDialog setBackgroundColorRes(@ColorRes int backgroundColorRes) {
        this.backgroundColor = this.getColor(backgroundColorRes);
        this.refreshUI();
        return this;
    }

    public long getEnterAnimDuration() {
        return this.enterAnimDuration;
    }

    public FullScreenDialog setEnterAnimDuration(long enterAnimDuration) {
        this.enterAnimDuration = enterAnimDuration;
        return this;
    }

    public long getExitAnimDuration() {
        return this.exitAnimDuration;
    }

    public FullScreenDialog setExitAnimDuration(long exitAnimDuration) {
        this.exitAnimDuration = exitAnimDuration;
        return this;
    }

    @Override
    public void onUIModeChange(Configuration newConfig) {
        if (this.dialogView != null) {
            FullScreenDialog.dismiss(this.dialogView);
        }
        if (this.getDialogImpl().boxCustom != null) {
            this.getDialogImpl().boxCustom.removeAllViews();
        }
        this.enterAnimDuration = 0L;
        this.dialogView = this.createView(this.isLightTheme() ? R.layout.layout_dialogx_fullscreen : R.layout.layout_dialogx_fullscreen_dark);
        this.dialogImpl = new DialogImpl(this.dialogView);
        if (this.dialogView != null) {
            this.dialogView.setTag((Object)this.me);
        }
        FullScreenDialog.show(this.dialogView);
    }

    public class DialogImpl
    implements DialogConvertViewInterface {
        private FullScreenDialogTouchEventInterceptor fullScreenDialogTouchEventInterceptor;
        public ActivityScreenShotImageView imgZoomActivity;
        public DialogXBaseRelativeLayout boxRoot;
        public RelativeLayout boxBkg;
        public MaxRelativeLayout bkg;
        public RelativeLayout boxCustom;
        public float bkgEnterAimY = -1.0f;
        private long enterAnimDurationTemp = 300L;

        public DialogImpl(View convertView) {
            if (convertView == null) {
                return;
            }
            this.imgZoomActivity = (ActivityScreenShotImageView)convertView.findViewById(R.id.img_zoom_activity);
            this.boxRoot = (DialogXBaseRelativeLayout)convertView.findViewById(R.id.box_root);
            this.boxBkg = (RelativeLayout)convertView.findViewById(R.id.box_bkg);
            this.bkg = (MaxRelativeLayout)convertView.findViewById(R.id.bkg);
            this.boxCustom = (RelativeLayout)convertView.findViewById(R.id.box_custom);
            this.init();
            FullScreenDialog.this.dialogImpl = this;
            this.refreshView();
        }

        @Override
        public void init() {
            this.boxRoot.setParentDialog(FullScreenDialog.this.me);
            this.boxRoot.setOnLifecycleCallBack(new DialogXBaseRelativeLayout.OnLifecycleCallBack(){

                @Override
                public void onShow() {
                    FullScreenDialog.this.isShow = true;
                    DialogImpl.this.boxRoot.setAlpha(0.0f);
                    FullScreenDialog.this.getDialogLifecycleCallback().onShow(FullScreenDialog.this.me);
                }

                @Override
                public void onDismiss() {
                    FullScreenDialog.this.isShow = false;
                    FullScreenDialog.this.getDialogLifecycleCallback().onDismiss(FullScreenDialog.this.me);
                }
            });
            this.boxRoot.setOnBackPressedListener(new OnBackPressedListener(){

                @Override
                public boolean onBackPressed() {
                    if (FullScreenDialog.this.onBackPressedListener != null && FullScreenDialog.this.onBackPressedListener.onBackPressed()) {
                        FullScreenDialog.this.dismiss();
                        return false;
                    }
                    if (FullScreenDialog.this.isCancelable()) {
                        FullScreenDialog.this.dismiss();
                    }
                    return false;
                }
            });
            this.fullScreenDialogTouchEventInterceptor = new FullScreenDialogTouchEventInterceptor(FullScreenDialog.this.me, FullScreenDialog.this.dialogImpl);
            this.enterAnimDurationTemp = 300L;
            if (overrideEnterDuration >= 0) {
                this.enterAnimDurationTemp = overrideEnterDuration;
            }
            if (FullScreenDialog.this.enterAnimDuration >= 0L) {
                this.enterAnimDurationTemp = FullScreenDialog.this.enterAnimDuration;
            }
            this.boxRoot.post(new Runnable(){

                @Override
                public void run() {
                    DialogImpl.this.bkgEnterAimY = DialogImpl.this.boxRoot.getSafeHeight() - (float)DialogImpl.this.boxCustom.getHeight();
                    if (DialogImpl.this.bkgEnterAimY < 0.0f) {
                        DialogImpl.this.bkgEnterAimY = 0.0f;
                    }
                    DialogImpl.this.boxRoot.animate().setDuration(DialogImpl.this.enterAnimDurationTemp).alpha(1.0f).setInterpolator((TimeInterpolator)new DecelerateInterpolator()).setListener(null);
                    ObjectAnimator exitAnim = ObjectAnimator.ofFloat((Object)((Object)DialogImpl.this.bkg), (String)"y", (float[])new float[]{DialogImpl.this.boxRoot.getHeight(), DialogImpl.this.bkgEnterAimY});
                    exitAnim.setDuration(DialogImpl.this.enterAnimDurationTemp);
                    exitAnim.start();
                }
            });
            this.bkg.setOnYChanged(new MaxRelativeLayout.OnYChanged(){

                @Override
                public void y(float y) {
                    float zoomScale = 1.0f - ((float)DialogImpl.this.boxRoot.getHeight() - y) * 2.0E-5f;
                    if (zoomScale > 1.0f) {
                        zoomScale = 1.0f;
                    }
                    DialogImpl.this.imgZoomActivity.setScaleX(zoomScale);
                    DialogImpl.this.imgZoomActivity.setScaleY(zoomScale);
                    DialogImpl.this.imgZoomActivity.setRadius((float)FullScreenDialog.this.dip2px(15.0f) * (((float)DialogImpl.this.boxRoot.getHeight() - y) / (float)DialogImpl.this.boxRoot.getHeight()));
                }
            });
            this.boxRoot.setOnSafeInsetsChangeListener(new OnSafeInsetsChangeListener(){

                @Override
                public void onChange(Rect unsafeRect) {
                    if (unsafeRect.bottom > FullScreenDialog.this.dip2px(100.0f)) {
                        ObjectAnimator enterAnim = ObjectAnimator.ofFloat((Object)((Object)DialogImpl.this.bkg), (String)"y", (float[])new float[]{DialogImpl.this.bkg.getY(), 0.0f});
                        enterAnim.setDuration(DialogImpl.this.enterAnimDurationTemp);
                        enterAnim.start();
                    }
                }
            });
        }

        @Override
        public void refreshView() {
            if (FullScreenDialog.this.backgroundColor != -1) {
                FullScreenDialog.this.tintColor((View)this.bkg, FullScreenDialog.this.backgroundColor);
            }
            if (FullScreenDialog.this.isCancelable()) {
                this.boxRoot.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        DialogImpl.this.doDismiss(v);
                    }
                });
            } else {
                this.boxRoot.setOnClickListener(null);
            }
            if (FullScreenDialog.this.onBindView != null && FullScreenDialog.this.onBindView.getCustomView() != null) {
                FullScreenDialog.this.onBindView.bindParent((ViewGroup)this.boxCustom, FullScreenDialog.this.me);
            }
            this.fullScreenDialogTouchEventInterceptor.refresh(FullScreenDialog.this.me, this);
        }

        @Override
        public void doDismiss(View v) {
            if (v != null) {
                v.setEnabled(false);
            }
            long exitAnimDurationTemp = 300L;
            if (overrideExitDuration >= 0) {
                exitAnimDurationTemp = overrideExitDuration;
            }
            if (FullScreenDialog.this.exitAnimDuration >= 0L) {
                exitAnimDurationTemp = FullScreenDialog.this.exitAnimDuration;
            }
            ObjectAnimator exitAnim = ObjectAnimator.ofFloat((Object)((Object)this.bkg), (String)"y", (float[])new float[]{this.bkg.getY(), this.boxBkg.getHeight()});
            exitAnim.setDuration(exitAnimDurationTemp);
            exitAnim.start();
            this.boxRoot.animate().alpha(0.0f).setInterpolator((TimeInterpolator)new AccelerateInterpolator()).setDuration(exitAnimDurationTemp);
            new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                @Override
                public void run() {
                    FullScreenDialog.dismiss(FullScreenDialog.this.dialogView);
                }
            }, exitAnimDurationTemp);
        }

        public void preDismiss() {
            if (FullScreenDialog.this.isCancelable()) {
                this.doDismiss((View)this.boxRoot);
            } else {
                long exitAnimDurationTemp = 300L;
                if (overrideExitDuration >= 0) {
                    exitAnimDurationTemp = overrideExitDuration;
                }
                if (FullScreenDialog.this.exitAnimDuration >= 0L) {
                    exitAnimDurationTemp = FullScreenDialog.this.exitAnimDuration;
                }
                ObjectAnimator enterAnim = ObjectAnimator.ofFloat((Object)((Object)this.bkg), (String)"y", (float[])new float[]{this.bkg.getY(), this.bkgEnterAimY});
                enterAnim.setDuration(exitAnimDurationTemp);
                enterAnim.start();
            }
        }
    }
}

