/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.util.views;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.widget.RelativeLayout;

public class RoundView
extends RelativeLayout {
    private float mRadius = 0.0f;
    private Path mBoundPath = null;

    public RoundView(Context context) {
        this(context, null);
    }

    public RoundView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RoundView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setWillNotDraw(false);
        this.mRadius = 50.0f;
    }

    public void setRadius(float radius) {
        if (this.mRadius == radius) {
            return;
        }
        this.mRadius = radius;
        this.postInvalidate();
    }

    public float getRadius() {
        return this.mRadius;
    }

    public void draw(Canvas canvas) {
        Rect rect = new Rect();
        this.getLocalVisibleRect(rect);
        this.mBoundPath = this.caculateRoundRectPath(rect);
        canvas.clipPath(this.mBoundPath);
        super.draw(canvas);
    }

    private Path caculateRoundRectPath(Rect r) {
        Path path = new Path();
        float radius = this.getRadius();
        float elevation = 0.0f;
        path.addRoundRect(new RectF((float)r.left + elevation, (float)r.top + elevation, (float)r.right - elevation, (float)r.bottom - elevation), radius, radius, Path.Direction.CW);
        return path;
    }
}

