/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.util.views;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import androidx.annotation.Nullable;
import com.kongzue.dialogx.DialogX;
import com.kongzue.dialogx.R;
import com.kongzue.dialogx.interfaces.ProgressViewInterface;

public class ProgressView
extends View
implements ProgressViewInterface {
    public static final int STATUS_LOADING = 0;
    public static final int STATUS_SUCCESS = 1;
    public static final int STATUS_WARNING = 2;
    public static final int STATUS_ERROR = 3;
    public static final int STATUS_PROGRESSING = 4;
    private int status = 0;
    private int width = this.dip2px(2.0f);
    private int color = -1;
    private ValueAnimator rotateAnimator;
    private ValueAnimator followAnimator;
    private float currentRotateDegrees;
    private float followRotateDegrees;
    private float halfSweepAMaxValue = 180.0f;
    private float halfSweepAMinValue = 80.0f;
    private float halfSweepA;
    Paint mPaint = new Paint();
    private boolean isInited = false;
    private float mCenterX;
    private float mCenterY;
    private float mRadius = 100.0f;
    private RectF oval;
    protected float oldAnimAngle;
    private int successStep = 0;
    private int line1X = 0;
    private int line1Y = 0;
    private int line2X = 0;
    private int line2Y = 0;
    private int tickStep = 0;
    private TimeInterpolator interpolator;
    private Runnable waitProgressingRunnable;
    private Runnable tickShowRunnable;
    private boolean noShowLoading;

    public ProgressView(Context context) {
        super(context);
        this.init(null);
    }

    public ProgressView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public ProgressView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    public ProgressView(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(AttributeSet attrs) {
        Class<ProgressView> clazz = ProgressView.class;
        synchronized (ProgressView.class) {
            if (this.isInited) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.isInited = true;
            if (attrs != null) {
                TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ProgressView);
                this.width = a.getDimensionPixelSize(R.styleable.ProgressView_progressStrokeWidth, this.dip2px(2.0f));
                this.color = a.getDimensionPixelSize(R.styleable.ProgressView_progressStrokeColor, this.color);
                a.recycle();
            }
            this.mPaint.setAntiAlias(true);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setStrokeWidth((float)this.width);
            this.mPaint.setStrokeCap(Paint.Cap.ROUND);
            this.mPaint.setColor(this.color);
            if (!this.isInEditMode()) {
                this.halfSweepA = (this.halfSweepAMaxValue - this.halfSweepAMinValue) / 2.0f;
                this.rotateAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 365.0f});
                this.rotateAnimator.setDuration(1000L);
                this.rotateAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
                this.rotateAnimator.setRepeatCount(-1);
                this.rotateAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animation) {
                        ProgressView.this.currentRotateDegrees = ((Float)animation.getAnimatedValue()).floatValue();
                        ProgressView.this.invalidate();
                    }
                });
                this.followAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 365.0f});
                this.followAnimator.setDuration(1500L);
                this.followAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
                this.followAnimator.setRepeatCount(-1);
                this.followAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animation) {
                        ProgressView.this.followRotateDegrees = ((Float)animation.getAnimatedValue()).floatValue();
                    }
                });
                this.followAnimator.start();
                this.rotateAnimator.start();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mCenterX = (float)w * 1.0f / 2.0f;
        this.mCenterY = (float)h * 1.0f / 2.0f;
        this.mRadius = Math.min(this.getWidth(), this.getHeight()) / 2 - this.width / 2;
        this.oval = new RectF(this.mCenterX - this.mRadius, this.mCenterY - this.mRadius, this.mCenterX + this.mRadius, this.mCenterY + this.mRadius);
    }

    protected void onDraw(Canvas canvas) {
        if (this.isInEditMode()) {
            canvas.drawArc(this.oval, 0.0f, 365.0f, false, this.mPaint);
            return;
        }
        if (this.noShowLoading) {
            canvas.drawArc(this.oval, 0.0f, 365.0f, false, this.mPaint);
            this.successStep = 2;
            this.drawDoneMark(this.status, canvas);
            return;
        }
        float sweepAngle = (float)((double)this.halfSweepA * Math.sin(Math.toRadians(this.followRotateDegrees))) + this.halfSweepA + this.halfSweepAMinValue / 2.0f;
        switch (this.status) {
            case 0: {
                canvas.drawArc(this.oval, this.currentRotateDegrees, -sweepAngle, false, this.mPaint);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                switch (this.successStep) {
                    case 0: {
                        canvas.drawArc(this.oval, this.currentRotateDegrees, -sweepAngle, false, this.mPaint);
                        if (!(this.currentRotateDegrees - sweepAngle > 270.0f)) break;
                        this.successStep = 1;
                        break;
                    }
                    case 1: {
                        float aimAngle = this.currentRotateDegrees > 270.0f ? this.currentRotateDegrees - 270.0f : 90.0f + this.currentRotateDegrees;
                        canvas.drawArc(this.oval, 270.0f, aimAngle, false, this.mPaint);
                        if (this.oldAnimAngle > aimAngle && this.oldAnimAngle > 300.0f) {
                            this.successStep = 2;
                            canvas.drawArc(this.oval, 0.0f, 360.0f, false, this.mPaint);
                            break;
                        }
                        this.oldAnimAngle = aimAngle;
                        break;
                    }
                    case 2: {
                        canvas.drawArc(this.oval, 0.0f, 360.0f, false, this.mPaint);
                        this.drawDoneMark(this.status, canvas);
                    }
                }
                break;
            }
            case 4: {
                canvas.drawArc(this.oval, -90.0f, this.currentRotateDegrees, false, this.mPaint);
                if (this.currentRotateDegrees != 365.0f || this.waitProgressingRunnable == null) break;
                this.waitProgressingRunnable.run();
                this.waitProgressingRunnable = null;
            }
        }
    }

    private void drawDoneMark(int status, Canvas canvas) {
        if (this.rotateAnimator.getInterpolator() != this.interpolator) {
            this.rotateAnimator.setInterpolator(this.interpolator);
        }
        if (this.tickShowRunnable != null) {
            this.tickShowRunnable.run();
            if (DialogX.useHaptic) {
                this.performHapticFeedback(0);
            }
            this.tickShowRunnable = null;
        }
        switch (status) {
            case 1: {
                this.showSuccessTick(canvas);
                break;
            }
            case 2: {
                this.showWarningTick(canvas);
                break;
            }
            case 3: {
                this.showErrorTick(canvas);
            }
        }
    }

    private void showSuccessTick(Canvas canvas) {
        int tickLeftPoint = (int)(this.mCenterX - this.mRadius * 1.0f / 2.0f);
        int tickTurnLeftPoint = (int)(this.mCenterX - this.mRadius / 10.0f);
        int tickRightPoint = (int)(this.mRadius * 0.99f);
        int speed = 2;
        switch (this.tickStep) {
            case 0: {
                if (tickLeftPoint + this.line1X < tickTurnLeftPoint) {
                    this.line1X += speed;
                    this.line1Y += speed;
                    break;
                }
                this.line2X = this.line1X;
                this.line2Y = this.line1Y;
                this.tickStep = 1;
                break;
            }
            case 1: {
                if (this.line2X >= tickRightPoint) break;
                this.line2X += 4;
                this.line2Y -= 5;
            }
        }
        canvas.drawLine((float)tickLeftPoint, this.mCenterY, (float)(tickLeftPoint + this.line1X), this.mCenterY + (float)this.line1Y, this.mPaint);
        canvas.drawLine((float)(tickLeftPoint + this.line1X), this.mCenterY + (float)this.line1Y, (float)(tickLeftPoint + this.line2X), this.mCenterY + (float)this.line2Y, this.mPaint);
        this.postInvalidateDelayed(1L);
    }

    private void showWarningTick(Canvas canvas) {
        int tickLeftPoint = (int)this.mCenterX;
        int line1StartY = (int)(this.mCenterY - this.mRadius * 1.0f / 2.0f);
        int line1EndY = (int)(this.mCenterY + this.mRadius * 1.0f / 8.0f);
        int line2StartY = (int)(this.mCenterY + this.mRadius * 3.0f / 7.0f);
        int speed = 4;
        switch (this.tickStep) {
            case 0: {
                if (this.line1Y < line1EndY - line1StartY) {
                    this.line1Y += speed;
                    break;
                }
                this.line1Y = line1EndY - line1StartY;
                this.tickStep = 1;
                break;
            }
            case 1: {
                if (this.line2Y == line2StartY) break;
                canvas.drawLine((float)tickLeftPoint, (float)line2StartY, (float)tickLeftPoint, (float)(line2StartY + 1), this.mPaint);
            }
        }
        canvas.drawLine((float)tickLeftPoint, (float)line1StartY, (float)tickLeftPoint, (float)(line1StartY + this.line1Y), this.mPaint);
        this.postInvalidateDelayed(this.tickStep == 1 ? 100L : 1L);
    }

    private void showErrorTick(Canvas canvas) {
        int tickLeftPoint = (int)(this.mCenterX - this.mRadius * 4.0f / 10.0f);
        int tickRightPoint = (int)(this.mCenterX + this.mRadius * 4.0f / 10.0f);
        int tickTopPoint = (int)(this.mCenterY - this.mRadius * 4.0f / 10.0f);
        int speed = 4;
        switch (this.tickStep) {
            case 0: {
                if (tickRightPoint - this.line1X > tickLeftPoint) {
                    this.line1X += speed;
                    this.line1Y += speed;
                    break;
                }
                this.tickStep = 1;
                canvas.drawLine((float)tickRightPoint, (float)tickTopPoint, (float)(tickRightPoint - this.line1X), (float)(tickTopPoint + this.line1Y), this.mPaint);
                this.postInvalidateDelayed(150L);
                return;
            }
            case 1: {
                if (tickLeftPoint + this.line2X < tickRightPoint) {
                    this.line2X += speed;
                    this.line2Y += speed;
                }
                canvas.drawLine((float)tickLeftPoint, (float)tickTopPoint, (float)(tickLeftPoint + this.line2X), (float)(tickTopPoint + this.line2Y), this.mPaint);
            }
        }
        canvas.drawLine((float)tickRightPoint, (float)tickTopPoint, (float)(tickRightPoint - this.line1X), (float)(tickTopPoint + this.line1Y), this.mPaint);
        this.postInvalidateDelayed(1L);
    }

    public void success() {
        if (this.status == 4) {
            this.progress(1.0f);
            this.waitProgressingRunnable = new Runnable(){

                @Override
                public void run() {
                    ProgressView.this.tickStep = 0;
                    ProgressView.this.successStep = 2;
                    ProgressView.this.interpolator = (TimeInterpolator)new AccelerateDecelerateInterpolator();
                    ProgressView.this.status = 1;
                }
            };
            return;
        }
        this.tickStep = 0;
        this.interpolator = new AccelerateDecelerateInterpolator();
        this.status = 1;
        this.invalidate();
    }

    public void warning() {
        if (this.status == 4) {
            this.progress(1.0f);
            this.waitProgressingRunnable = new Runnable(){

                @Override
                public void run() {
                    ProgressView.this.tickStep = 0;
                    ProgressView.this.successStep = 2;
                    ProgressView.this.interpolator = (TimeInterpolator)new DecelerateInterpolator(2.0f);
                    ProgressView.this.status = 2;
                }
            };
            return;
        }
        this.tickStep = 0;
        this.interpolator = new DecelerateInterpolator(2.0f);
        this.status = 2;
        this.invalidate();
    }

    public void error() {
        if (this.status == 4) {
            this.progress(1.0f);
            this.waitProgressingRunnable = new Runnable(){

                @Override
                public void run() {
                    ProgressView.this.tickStep = 0;
                    ProgressView.this.successStep = 2;
                    ProgressView.this.interpolator = (TimeInterpolator)new DecelerateInterpolator(2.0f);
                    ProgressView.this.status = 3;
                }
            };
            return;
        }
        this.tickStep = 0;
        this.interpolator = new DecelerateInterpolator(2.0f);
        this.status = 3;
        this.invalidate();
    }

    public void progress(float progress) {
        if (this.rotateAnimator != null) {
            this.rotateAnimator.cancel();
        }
        if (this.followAnimator != null) {
            this.followAnimator.cancel();
        }
        if (this.status != 4) {
            this.currentRotateDegrees = 0.0f;
        }
        this.rotateAnimator = ValueAnimator.ofFloat((float[])new float[]{this.currentRotateDegrees, 365.0f * progress});
        this.rotateAnimator.setDuration(1000L);
        this.rotateAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator(2.0f));
        this.rotateAnimator.setRepeatCount(0);
        this.rotateAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ProgressView.this.currentRotateDegrees = ((Float)animation.getAnimatedValue()).floatValue();
                ProgressView.this.invalidate();
            }
        });
        this.rotateAnimator.start();
        this.status = 4;
    }

    public ProgressView whenShowTick(Runnable runnable) {
        this.tickShowRunnable = runnable;
        return this;
    }

    public void loading() {
        this.noShowLoading = false;
        this.oldAnimAngle = 0.0f;
        this.successStep = 0;
        this.line1X = 0;
        this.line1Y = 0;
        this.line2X = 0;
        this.line2Y = 0;
        this.status = 0;
        if (this.rotateAnimator != null) {
            this.rotateAnimator.cancel();
        }
        if (this.followAnimator != null) {
            this.followAnimator.cancel();
        }
        this.isInited = false;
        this.init(null);
    }

    public int getStatus() {
        return this.status;
    }

    protected void onDetachedFromWindow() {
        if (this.rotateAnimator != null) {
            this.rotateAnimator.cancel();
        }
        if (this.followAnimator != null) {
            this.followAnimator.cancel();
        }
        super.onDetachedFromWindow();
    }

    public int getStrokeWidth() {
        return this.width;
    }

    public ProgressView setStrokeWidth(int width) {
        this.width = width;
        if (this.mPaint != null) {
            this.mPaint.setStrokeWidth((float)width);
        }
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public ProgressView setColor(int color2) {
        this.color = color2;
        if (this.mPaint != null) {
            this.mPaint.setColor(color2);
        }
        return this;
    }

    public void noLoading() {
        this.noShowLoading = true;
    }

    private int dip2px(float dpValue) {
        float scale = Resources.getSystem().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }
}

