/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.util.views;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import com.kongzue.dialogx.R;

public class MaxRelativeLayout
extends RelativeLayout {
    private int maxWidth;
    private int maxHeight;
    private int minWidth;
    private int minHeight;
    private boolean lockWidth;
    private boolean interceptTouch = true;
    private float startAnimValue = 0.0f;
    private float endAnimValue = 0.0f;
    private ScrollView childScrollView;
    private int preWidth = -1;
    private OnYChanged onYChangedListener;
    private View.OnTouchListener onTouchListener;

    public MaxRelativeLayout(Context context) {
        super(context);
        this.init(context, null);
    }

    public MaxRelativeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public MaxRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.MaxRelativeLayout);
            this.maxWidth = a.getDimensionPixelSize(R.styleable.MaxRelativeLayout_maxLayoutWidth, 0);
            this.maxHeight = a.getDimensionPixelSize(R.styleable.MaxRelativeLayout_maxLayoutHeight, 0);
            this.lockWidth = a.getBoolean(R.styleable.MaxRelativeLayout_lockWidth, false);
            this.interceptTouch = a.getBoolean(R.styleable.MaxRelativeLayout_interceptTouch, true);
            a.recycle();
        }
        this.minWidth = this.getMinimumWidth();
        this.minHeight = this.getMinimumHeight();
        if (!this.isInEditMode() && Build.VERSION.SDK_INT >= 19) {
            this.animate().setUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    float progress = ((Float)animation.getAnimatedValue()).floatValue();
                    long value = (long)(MaxRelativeLayout.this.startAnimValue + (MaxRelativeLayout.this.endAnimValue - MaxRelativeLayout.this.startAnimValue) * progress);
                    if (MaxRelativeLayout.this.onYChangedListener != null) {
                        MaxRelativeLayout.this.onYChangedListener.y(value);
                    }
                }
            });
        }
    }

    public MaxRelativeLayout setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
        return this;
    }

    public MaxRelativeLayout setMaxWidth(int maxWidth) {
        if (maxWidth > 0) {
            this.maxWidth = maxWidth;
        }
        return this;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        if (this.preWidth == -1 && widthSize != 0) {
            this.preWidth = widthSize;
        }
        if (this.lockWidth) {
            this.maxWidth = Math.min(this.maxWidth, Math.min(widthSize, this.preWidth));
        }
        if (this.maxHeight > 0) {
            heightSize = Math.min(heightSize, this.maxHeight);
        }
        if (this.maxWidth > 0) {
            widthSize = Math.min(widthSize, this.maxWidth);
        }
        View blurView = this.findViewWithTag("blurView");
        View contentView = this.findViewWithoutTag("blurView");
        if (contentView != null) {
            int heightTemp;
            int widthTemp = contentView.getMeasuredWidth() == 0 ? this.getMeasuredWidth() : contentView.getMeasuredWidth();
            int n = heightTemp = contentView.getMeasuredHeight() == 0 ? this.getMeasuredHeight() : contentView.getMeasuredHeight();
            if (widthTemp < this.minWidth) {
                widthTemp = this.minWidth;
            }
            if (heightTemp < this.minHeight) {
                heightTemp = this.minHeight;
            }
            if (blurView != null) {
                if (heightMode == 0x40000000) {
                    heightTemp = heightSize;
                }
                if (widthMode == 0x40000000) {
                    widthTemp = widthSize;
                }
                RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)blurView.getLayoutParams();
                lp.width = widthTemp;
                lp.height = heightTemp;
                blurView.setLayoutParams((ViewGroup.LayoutParams)lp);
            }
        } else if (blurView != null) {
            RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)blurView.getLayoutParams();
            lp.width = this.getMeasuredWidth();
            lp.height = this.getMeasuredHeight();
            blurView.setLayoutParams((ViewGroup.LayoutParams)lp);
        }
        int maxHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)heightSize, (int)heightMode);
        int maxWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)widthMode);
        super.onMeasure(maxWidthMeasureSpec, maxHeightMeasureSpec);
        this.childScrollView = (ScrollView)this.findViewById(R.id.scrollView);
    }

    private View findViewWithoutTag(String tag) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (tag.equals(this.getChildAt(i).getTag())) continue;
            return this.getChildAt(i);
        }
        return null;
    }

    public boolean isChildScrollViewCanScroll() {
        if (this.childScrollView == null) {
            return false;
        }
        if (!this.childScrollView.isEnabled()) {
            return false;
        }
        View child = this.childScrollView.getChildAt(0);
        if (child != null) {
            int childHeight = child.getHeight();
            return this.childScrollView.getHeight() < childHeight;
        }
        return false;
    }

    public int dip2px(float dpValue) {
        float scale = this.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public boolean isLockWidth() {
        return this.lockWidth;
    }

    public MaxRelativeLayout setLockWidth(boolean lockWidth) {
        this.lockWidth = lockWidth;
        return this;
    }

    public void setY(float y) {
        super.setY(y);
    }

    public OnYChanged getOnYChanged() {
        return this.onYChangedListener;
    }

    public MaxRelativeLayout setOnYChanged(OnYChanged onYChanged) {
        this.onYChangedListener = onYChanged;
        return this;
    }

    public void setTranslationY(float translationY) {
        super.setTranslationY(translationY);
        if (this.onYChangedListener != null) {
            this.onYChangedListener.y(translationY);
        }
    }

    public void setOnTouchListener(View.OnTouchListener l) {
        this.onTouchListener = l;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (this.onTouchListener != null) {
            this.onTouchListener.onTouch((View)this, ev);
        }
        return super.dispatchTouchEvent(ev);
    }

    public static interface OnYChanged {
        public void y(float var1);
    }
}

