/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.util;

import android.app.Activity;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.kongzue.dialogx.dialogs.PopTip;
import com.kongzue.dialogx.interfaces.BaseDialog;

public class WindowUtil {
    public static void show(final Activity activity, final View dialogView, final boolean touchEnable) {
        block4: {
            try {
                if (activity.getWindow().getDecorView().isAttachedToWindow()) {
                    WindowUtil.showNow(activity, dialogView, touchEnable);
                } else {
                    activity.getWindow().getDecorView().post(new Runnable(){

                        @Override
                        public void run() {
                            WindowUtil.showNow(activity, dialogView, touchEnable);
                        }
                    });
                }
            }
            catch (Exception e) {
                if (activity == null || activity.isDestroyed()) break block4;
                WindowUtil.showNow(activity, dialogView, touchEnable);
            }
        }
    }

    private static void showNow(final Activity activity, View dialogView, boolean touchEnable) {
        WindowManager manager = (WindowManager)activity.getSystemService("window");
        WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams();
        layoutParams.gravity = 16;
        layoutParams.format = -2;
        layoutParams.type = 1003;
        layoutParams.flags = 0xC000500;
        if (!touchEnable) {
            dialogView.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    for (BaseDialog baseDialog : BaseDialog.getRunningDialogList()) {
                        if (baseDialog instanceof PopTip || baseDialog.isCancelable() || baseDialog.getActivity() != activity) continue;
                        if (baseDialog.getDialogView() == null) {
                            return false;
                        }
                        return baseDialog.getDialogView().dispatchTouchEvent(event);
                    }
                    return activity.dispatchTouchEvent(event);
                }
            });
        }
        if (Build.VERSION.SDK_INT >= 28) {
            layoutParams.layoutInDisplayCutoutMode = 1;
        }
        manager.addView(dialogView, (ViewGroup.LayoutParams)layoutParams);
    }

    public static void dismiss(View dialogView) {
        BaseDialog baseDialog = (BaseDialog)dialogView.getTag();
        if (baseDialog != null && baseDialog.getActivity() != null) {
            WindowManager manager = (WindowManager)baseDialog.getActivity().getSystemService("window");
            manager.removeViewImmediate(dialogView);
        }
    }
}

