/*
 * Decompiled with CFR 0.152.
 */
package com.kongzue.dialogx.dialogs;

import android.content.res.Configuration;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import com.kongzue.dialogx.DialogX;
import com.kongzue.dialogx.R;
import com.kongzue.dialogx.dialogs.MessageDialog;
import com.kongzue.dialogx.interfaces.BaseDialog;
import com.kongzue.dialogx.interfaces.OnBackPressedListener;
import com.kongzue.dialogx.interfaces.OnBindView;
import com.kongzue.dialogx.interfaces.OnInputDialogButtonClickListener;
import com.kongzue.dialogx.util.InputInfo;
import com.kongzue.dialogx.util.TextInfo;

public class InputDialog
extends MessageDialog {
    protected InputDialog() {
    }

    public static InputDialog build() {
        return new InputDialog();
    }

    public static InputDialog build(OnBindView<MessageDialog> onBindView) {
        return new InputDialog().setCustomView((OnBindView)onBindView);
    }

    public InputDialog(CharSequence title, CharSequence message, CharSequence okText) {
        this.cancelable = DialogX.cancelable;
        this.title = title;
        this.message = message;
        this.okText = okText;
    }

    public InputDialog(int titleResId, int messageResId, int okTextResId) {
        this.cancelable = DialogX.cancelable;
        this.title = this.getString(titleResId);
        this.message = this.getString(messageResId);
        this.okText = this.getString(okTextResId);
    }

    public static InputDialog show(CharSequence title, CharSequence message, CharSequence okText) {
        InputDialog inputDialog = new InputDialog(title, message, okText);
        inputDialog.show();
        return inputDialog;
    }

    public static InputDialog show(int titleResId, int messageResId, int okTextResId) {
        InputDialog inputDialog = new InputDialog(titleResId, messageResId, okTextResId);
        inputDialog.show();
        return inputDialog;
    }

    public InputDialog(CharSequence title, CharSequence message, CharSequence okText, CharSequence cancelText) {
        this.cancelable = DialogX.cancelable;
        this.title = title;
        this.message = message;
        this.okText = okText;
        this.cancelText = cancelText;
    }

    public InputDialog(int titleResId, int messageResId, int okTextResId, int cancelTextResId) {
        this.cancelable = DialogX.cancelable;
        this.title = this.getString(titleResId);
        this.message = this.getString(messageResId);
        this.okText = this.getString(okTextResId);
        this.cancelText = this.getString(cancelTextResId);
    }

    public static InputDialog show(CharSequence title, CharSequence message, CharSequence okText, CharSequence cancelText) {
        InputDialog inputDialog = new InputDialog(title, message, okText, cancelText);
        inputDialog.show();
        return inputDialog;
    }

    public static InputDialog show(int titleResId, int messageResId, int okTextResId, int cancelTextResId) {
        InputDialog inputDialog = new InputDialog(titleResId, messageResId, okTextResId, cancelTextResId);
        inputDialog.show();
        return inputDialog;
    }

    public InputDialog(CharSequence title, CharSequence message, CharSequence okText, CharSequence cancelText, String inputText) {
        this.cancelable = DialogX.cancelable;
        this.title = title;
        this.message = message;
        this.okText = okText;
        this.cancelText = cancelText;
        this.inputText = inputText;
    }

    public static InputDialog show(CharSequence title, CharSequence message, CharSequence okText, CharSequence cancelText, String inputText) {
        InputDialog inputDialog = new InputDialog(title, message, okText, cancelText, inputText);
        inputDialog.show();
        return inputDialog;
    }

    public InputDialog(CharSequence title, CharSequence message, CharSequence okText, CharSequence cancelText, CharSequence otherText) {
        this.cancelable = DialogX.cancelable;
        this.title = title;
        this.message = message;
        this.okText = okText;
        this.cancelText = cancelText;
        this.otherText = otherText;
    }

    public InputDialog(int titleResId, int messageResId, int okTextResId, int cancelTextResId, int otherTextResId) {
        this.cancelable = DialogX.cancelable;
        this.title = this.getString(titleResId);
        this.message = this.getString(messageResId);
        this.okText = this.getString(okTextResId);
        this.cancelText = this.getString(cancelTextResId);
        this.otherText = this.getString(otherTextResId);
    }

    public static InputDialog show(CharSequence title, CharSequence message, CharSequence okText, CharSequence cancelText, CharSequence otherText) {
        InputDialog inputDialog = new InputDialog(title, message, okText, cancelText, otherText);
        inputDialog.show();
        return inputDialog;
    }

    public static InputDialog show(int titleResId, int messageResId, int okTextResId, int cancelTextResId, int otherTextResId) {
        InputDialog inputDialog = new InputDialog(titleResId, messageResId, okTextResId, cancelTextResId, otherTextResId);
        inputDialog.show();
        return inputDialog;
    }

    public InputDialog(CharSequence title, CharSequence message, CharSequence okText, CharSequence cancelText, CharSequence otherText, String inputText) {
        this.cancelable = DialogX.cancelable;
        this.title = title;
        this.message = message;
        this.okText = okText;
        this.cancelText = cancelText;
        this.otherText = otherText;
        this.inputText = inputText;
    }

    public InputDialog(int titleResId, int messageResId, int okTextResId, int cancelTextResId, int otherTextResId, int inputTextResId) {
        this.cancelable = DialogX.cancelable;
        this.title = this.getString(titleResId);
        this.message = this.getString(messageResId);
        this.okText = this.getString(okTextResId);
        this.cancelText = this.getString(cancelTextResId);
        this.otherText = this.getString(otherTextResId);
        this.inputText = this.getString(inputTextResId);
    }

    public static InputDialog show(CharSequence title, CharSequence message, CharSequence okText, CharSequence cancelText, CharSequence otherText, String inputText) {
        InputDialog inputDialog = new InputDialog(title, message, okText, cancelText, otherText, inputText);
        inputDialog.show();
        return inputDialog;
    }

    public static InputDialog show(int titleResId, int messageResId, int okTextResId, int cancelTextResId, int otherTextResId, int inputTextResId) {
        InputDialog inputDialog = new InputDialog(titleResId, messageResId, okTextResId, cancelTextResId, otherTextResId, inputTextResId);
        inputDialog.show();
        return inputDialog;
    }

    @Override
    public String dialogKey() {
        return this.getClass().getSimpleName() + "(" + Integer.toHexString(this.hashCode()) + ")";
    }

    @Override
    public CharSequence getOkButton() {
        return this.okText;
    }

    @Override
    public InputDialog setOkButton(CharSequence okText) {
        this.okText = okText;
        this.refreshUI();
        return this;
    }

    @Override
    public InputDialog setOkButton(int okTextResId) {
        this.okText = this.getString(okTextResId);
        this.refreshUI();
        return this;
    }

    public InputDialog setOkButton(OnInputDialogButtonClickListener<InputDialog> okButtonClickListener) {
        this.okButtonClickListener = okButtonClickListener;
        return this;
    }

    public InputDialog setOkButton(CharSequence okText, OnInputDialogButtonClickListener<InputDialog> okButtonClickListener) {
        this.okText = okText;
        this.okButtonClickListener = okButtonClickListener;
        this.refreshUI();
        return this;
    }

    public InputDialog setOkButton(int okTextResId, OnInputDialogButtonClickListener<InputDialog> okButtonClickListener) {
        this.okText = this.getString(okTextResId);
        this.okButtonClickListener = okButtonClickListener;
        this.refreshUI();
        return this;
    }

    @Override
    public CharSequence getCancelButton() {
        return this.cancelText;
    }

    @Override
    public InputDialog setCancelButton(CharSequence cancelText) {
        this.cancelText = cancelText;
        this.refreshUI();
        return this;
    }

    @Override
    public InputDialog setCancelButton(int cancelTextResId) {
        this.cancelText = this.getString(cancelTextResId);
        this.refreshUI();
        return this;
    }

    public InputDialog setCancelButton(OnInputDialogButtonClickListener<InputDialog> cancelButtonClickListener) {
        this.cancelButtonClickListener = cancelButtonClickListener;
        return this;
    }

    public InputDialog setCancelButton(CharSequence cancelText, OnInputDialogButtonClickListener<InputDialog> cancelButtonClickListener) {
        this.cancelText = cancelText;
        this.cancelButtonClickListener = cancelButtonClickListener;
        this.refreshUI();
        return this;
    }

    public InputDialog setCancelButton(int cancelTextResId, OnInputDialogButtonClickListener<InputDialog> cancelButtonClickListener) {
        this.cancelText = this.getString(cancelTextResId);
        this.cancelButtonClickListener = cancelButtonClickListener;
        this.refreshUI();
        return this;
    }

    @Override
    public CharSequence getOtherButton() {
        return this.otherText;
    }

    @Override
    public InputDialog setOtherButton(CharSequence otherText) {
        this.otherText = otherText;
        this.refreshUI();
        return this;
    }

    @Override
    public InputDialog setOtherButton(int otherTextResId) {
        this.otherText = this.getString(otherTextResId);
        this.refreshUI();
        return this;
    }

    public InputDialog setOtherButton(OnInputDialogButtonClickListener<InputDialog> otherButtonClickListener) {
        this.otherButtonClickListener = otherButtonClickListener;
        return this;
    }

    public InputDialog setOtherButton(CharSequence otherText, OnInputDialogButtonClickListener<InputDialog> otherButtonClickListener) {
        this.otherText = otherText;
        this.otherButtonClickListener = otherButtonClickListener;
        this.refreshUI();
        return this;
    }

    public InputDialog setOtherButton(int otherTextResId, OnInputDialogButtonClickListener<InputDialog> otherButtonClickListener) {
        this.otherText = this.getString(otherTextResId);
        this.otherButtonClickListener = otherButtonClickListener;
        this.refreshUI();
        return this;
    }

    public OnInputDialogButtonClickListener<InputDialog> getInputOkButtonClickListener() {
        return (OnInputDialogButtonClickListener)this.okButtonClickListener;
    }

    public InputDialog setOkButtonClickListener(OnInputDialogButtonClickListener<InputDialog> okButtonClickListener) {
        this.okButtonClickListener = okButtonClickListener;
        return this;
    }

    public OnInputDialogButtonClickListener getInputCancelButtonClickListener() {
        return (OnInputDialogButtonClickListener)this.cancelButtonClickListener;
    }

    public InputDialog setCancelButtonClickListener(OnInputDialogButtonClickListener<InputDialog> cancelButtonClickListener) {
        this.cancelButtonClickListener = cancelButtonClickListener;
        return this;
    }

    public OnInputDialogButtonClickListener getInputOtherButtonClickListener() {
        return (OnInputDialogButtonClickListener)this.otherButtonClickListener;
    }

    public InputDialog setOtherButtonClickListener(OnInputDialogButtonClickListener<InputDialog> otherButtonClickListener) {
        this.otherButtonClickListener = otherButtonClickListener;
        return this;
    }

    @Override
    public CharSequence getTitle() {
        return this.title;
    }

    @Override
    public InputDialog setTitle(CharSequence title) {
        this.title = title;
        this.refreshUI();
        return this;
    }

    @Override
    public InputDialog setTitle(int titleResId) {
        this.title = this.getString(titleResId);
        this.refreshUI();
        return this;
    }

    @Override
    public CharSequence getMessage() {
        return this.message;
    }

    @Override
    public InputDialog setMessage(CharSequence message) {
        this.message = message;
        this.refreshUI();
        return this;
    }

    @Override
    public InputDialog setMessage(int messageResId) {
        this.message = this.getString(messageResId);
        this.refreshUI();
        return this;
    }

    @Override
    public String getInputText() {
        if (this.getDialogImpl() != null && this.getDialogImpl().txtInput != null) {
            return this.getDialogImpl().txtInput.getText().toString();
        }
        return this.inputText;
    }

    public InputDialog setInputText(String inputText) {
        this.inputText = inputText;
        this.refreshUI();
        return this;
    }

    public InputDialog setInputText(int inputTextResId) {
        this.inputText = this.getString(inputTextResId);
        this.refreshUI();
        return this;
    }

    public String getInputHintText() {
        return this.inputHintText;
    }

    public InputDialog setInputHintText(String inputHintText) {
        this.inputHintText = inputHintText;
        this.refreshUI();
        return this;
    }

    public InputDialog setInputHintText(int inputHintTextResId) {
        this.inputHintText = this.getString(inputHintTextResId);
        this.refreshUI();
        return this;
    }

    @Override
    public TextInfo getTitleTextInfo() {
        return this.titleTextInfo;
    }

    @Override
    public InputDialog setTitleTextInfo(TextInfo titleTextInfo) {
        this.titleTextInfo = titleTextInfo;
        this.refreshUI();
        return this;
    }

    @Override
    public TextInfo getMessageTextInfo() {
        return this.messageTextInfo;
    }

    @Override
    public InputDialog setMessageTextInfo(TextInfo messageTextInfo) {
        this.messageTextInfo = messageTextInfo;
        this.refreshUI();
        return this;
    }

    @Override
    public TextInfo getOkTextInfo() {
        return this.okTextInfo;
    }

    @Override
    public InputDialog setOkTextInfo(TextInfo okTextInfo) {
        this.okTextInfo = okTextInfo;
        this.refreshUI();
        return this;
    }

    @Override
    public TextInfo getCancelTextInfo() {
        return this.cancelTextInfo;
    }

    @Override
    public InputDialog setCancelTextInfo(TextInfo cancelTextInfo) {
        this.cancelTextInfo = cancelTextInfo;
        this.refreshUI();
        return this;
    }

    @Override
    public TextInfo getOtherTextInfo() {
        return this.otherTextInfo;
    }

    @Override
    public InputDialog setOtherTextInfo(TextInfo otherTextInfo) {
        this.otherTextInfo = otherTextInfo;
        this.refreshUI();
        return this;
    }

    public InputInfo getInputInfo() {
        return this.inputInfo;
    }

    public InputDialog setInputInfo(InputInfo inputInfo) {
        this.inputInfo = inputInfo;
        this.refreshUI();
        return this;
    }

    @Override
    public int getButtonOrientation() {
        return this.buttonOrientation;
    }

    @Override
    public InputDialog setButtonOrientation(int buttonOrientation) {
        this.buttonOrientation = buttonOrientation;
        this.refreshUI();
        return this;
    }

    @Override
    public boolean isCancelable() {
        if (this.privateCancelable != null) {
            return this.privateCancelable == BaseDialog.BOOLEAN.TRUE;
        }
        if (overrideCancelable != null) {
            return overrideCancelable == BaseDialog.BOOLEAN.TRUE;
        }
        return this.cancelable;
    }

    @Override
    public InputDialog setCancelable(boolean cancelable) {
        this.privateCancelable = cancelable ? BaseDialog.BOOLEAN.TRUE : BaseDialog.BOOLEAN.FALSE;
        this.refreshUI();
        return this;
    }

    @Override
    public OnBackPressedListener getOnBackPressedListener() {
        return this.onBackPressedListener;
    }

    @Override
    public InputDialog setOnBackPressedListener(OnBackPressedListener onBackPressedListener) {
        this.onBackPressedListener = onBackPressedListener;
        return this;
    }

    public boolean isAutoShowInputKeyboard() {
        return this.autoShowInputKeyboard;
    }

    public InputDialog setAutoShowInputKeyboard(boolean autoShowInputKeyboard) {
        this.autoShowInputKeyboard = autoShowInputKeyboard;
        return this;
    }

    @Override
    public InputDialog setCustomView(OnBindView<MessageDialog> onBindView) {
        this.onBindView = onBindView;
        this.refreshUI();
        return this;
    }

    @Override
    public View getCustomView() {
        if (this.onBindView == null) {
            return null;
        }
        return this.onBindView.getCustomView();
    }

    @Override
    public InputDialog removeCustomView() {
        this.onBindView.clean();
        this.refreshUI();
        return this;
    }

    @Override
    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public InputDialog setBackgroundColor(@ColorInt int backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.refreshUI();
        return this;
    }

    @Override
    public InputDialog setBackgroundColorRes(@ColorRes int backgroundColorResId) {
        this.backgroundColor = this.getColor(backgroundColorResId);
        this.refreshUI();
        return this;
    }

    @Override
    public InputDialog setMaskColor(@ColorInt int maskColor) {
        this.maskColor = maskColor;
        this.refreshUI();
        return this;
    }

    @Override
    public long getEnterAnimDuration() {
        return this.enterAnimDuration;
    }

    @Override
    public InputDialog setEnterAnimDuration(long enterAnimDuration) {
        this.enterAnimDuration = enterAnimDuration;
        return this;
    }

    @Override
    public long getExitAnimDuration() {
        return this.exitAnimDuration;
    }

    @Override
    public InputDialog setExitAnimDuration(long exitAnimDuration) {
        this.exitAnimDuration = exitAnimDuration;
        return this;
    }

    @Override
    public void onUIModeChange(Configuration newConfig) {
        int layoutId;
        if (this.dialogView != null) {
            InputDialog.dismiss(this.dialogView);
        }
        if (this.getDialogImpl().boxCustom != null) {
            this.getDialogImpl().boxCustom.removeAllViews();
        }
        layoutId = (layoutId = this.style.layout(this.isLightTheme())) == 0 ? (this.isLightTheme() ? R.layout.layout_dialogx_material : R.layout.layout_dialogx_material_dark) : layoutId;
        String inputText = this.getInputText();
        this.enterAnimDuration = 0L;
        this.dialogView = this.createView(layoutId);
        this.dialogImpl = new MessageDialog.DialogImpl(this, this.dialogView);
        if (this.dialogView != null) {
            this.dialogView.setTag((Object)this.me);
        }
        InputDialog.show(this.dialogView);
        this.setInputText(inputText);
    }

    @Override
    public InputDialog setAnimResId(int enterResId, int exitResId) {
        this.customEnterAnimResId = enterResId;
        this.customExitAnimResId = exitResId;
        return this;
    }

    @Override
    public InputDialog setEnterAnimResId(int enterResId) {
        this.customEnterAnimResId = enterResId;
        return this;
    }

    @Override
    public InputDialog setExitAnimResId(int exitResId) {
        this.customExitAnimResId = exitResId;
        return this;
    }
}

