/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.mavenplugin;

import com.github.kongchen.swagger.docgen.AbstractDocumentSource;
import com.github.kongchen.swagger.docgen.GenerateException;
import com.github.kongchen.swagger.docgen.mavenplugin.ApiSource;
import com.github.kongchen.swagger.docgen.mavenplugin.MavenDocumentSource;
import com.github.kongchen.swagger.docgen.mavenplugin.SpringMavenDocumentSource;
import io.swagger.util.Json;
import java.io.File;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

@Mojo(name="generate", defaultPhase=LifecyclePhase.COMPILE, configurator="include-project-dependencies", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class ApiDocumentMojo
extends AbstractMojo {
    @Parameter
    private List<ApiSource> apiSources;
    @Parameter
    private List<String> enabledObjectMapperFeatures;
    @Parameter
    private List<String> disabledObjectMapperFeatures;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    private String projectEncoding;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(property="swagger.skip", defaultValue="false")
    private boolean skipSwaggerGeneration;
    @Parameter(property="file.encoding")
    private String encoding;

    public List<ApiSource> getApiSources() {
        return this.apiSources;
    }

    public void setApiSources(List<ApiSource> apiSources) {
        this.apiSources = apiSources;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.project != null) {
            this.projectEncoding = this.project.getProperties().getProperty("project.build.sourceEncoding");
        }
        if (this.skipSwaggerGeneration) {
            this.getLog().info((CharSequence)"Swagger generation is skipped.");
            return;
        }
        if (this.apiSources == null) {
            throw new MojoFailureException("You must configure at least one apiSources element");
        }
        if (this.useSwaggerSpec11()) {
            throw new MojoExecutionException("You may use an old version of swagger which is not supported by swagger-maven-plugin 2.0+\nswagger-maven-plugin 2.0+ only supports swagger-core 1.3.x");
        }
        if (this.useSwaggerSpec13()) {
            throw new MojoExecutionException("You may use an old version of swagger which is not supported by swagger-maven-plugin 3.0+\nswagger-maven-plugin 3.0+ only supports swagger spec 2.0");
        }
        try {
            this.getLog().debug((CharSequence)this.apiSources.toString());
            if (this.enabledObjectMapperFeatures != null) {
                this.configureObjectMapperFeatures(this.enabledObjectMapperFeatures, true);
            }
            if (this.disabledObjectMapperFeatures != null) {
                this.configureObjectMapperFeatures(this.disabledObjectMapperFeatures, false);
            }
            for (ApiSource apiSource : this.apiSources) {
                String outputFormats;
                this.validateConfiguration(apiSource);
                AbstractDocumentSource documentSource = apiSource.isSpringmvc() ? new SpringMavenDocumentSource(apiSource, this.getLog(), this.projectEncoding) : new MavenDocumentSource(apiSource, this.getLog(), this.projectEncoding);
                documentSource.loadTypesToSkip();
                documentSource.loadModelModifier();
                documentSource.loadModelConverters();
                documentSource.loadDocuments();
                this.createOutputDirs(apiSource.getOutputPath());
                if (apiSource.getTemplatePath() != null) {
                    documentSource.toDocuments();
                }
                String swaggerFileName = this.getSwaggerFileName(apiSource.getSwaggerFileName());
                documentSource.toSwaggerDocuments(apiSource.getSwaggerUIDocBasePath() == null ? apiSource.getBasePath() : apiSource.getSwaggerUIDocBasePath(), apiSource.getOutputFormats(), swaggerFileName, this.projectEncoding);
                if (!apiSource.isAttachSwaggerArtifact() || apiSource.getSwaggerDirectory() == null || this.project == null || (outputFormats = apiSource.getOutputFormats()) == null) continue;
                for (String format : outputFormats.split(",")) {
                    String classifier = swaggerFileName.equals("swagger") ? this.getSwaggerDirectoryName(apiSource.getSwaggerDirectory()) : swaggerFileName;
                    File swaggerFile = new File(apiSource.getSwaggerDirectory(), swaggerFileName + "." + format.toLowerCase());
                    this.projectHelper.attachArtifact(this.project, format.toLowerCase(), classifier, swaggerFile);
                }
            }
        }
        catch (GenerateException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void createOutputDirs(String outputPath) throws MojoExecutionException {
        File outputDirectory;
        if (outputPath != null && (outputDirectory = new File(outputPath).getParentFile()) != null && !outputDirectory.exists() && !outputDirectory.mkdirs()) {
            throw new MojoExecutionException(String.format("Create directory [%s] for output failed.", outputPath));
        }
    }

    private void validateConfiguration(ApiSource apiSource) throws GenerateException {
        if (apiSource == null) {
            throw new GenerateException("You do not configure any apiSource!");
        }
        if (apiSource.getInfo() == null) {
            throw new GenerateException("`<info>` is required by Swagger Spec.");
        }
        if (apiSource.getInfo().getTitle() == null) {
            throw new GenerateException("`<info><title>` is required by Swagger Spec.");
        }
        if (apiSource.getInfo().getVersion() == null) {
            throw new GenerateException("`<info><version>` is required by Swagger Spec.");
        }
        if (apiSource.getInfo().getLicense() != null && apiSource.getInfo().getLicense().getName() == null) {
            throw new GenerateException("`<info><license><name>` is required by Swagger Spec.");
        }
        if (apiSource.getLocations() == null) {
            throw new GenerateException("<locations> is required by this plugin.");
        }
    }

    private boolean useSwaggerSpec11() {
        try {
            Class<?> tryClass = Class.forName("com.wordnik.swagger.annotations.ApiErrors");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private boolean useSwaggerSpec13() {
        try {
            Class<?> tryClass = Class.forName("com.wordnik.swagger.model.ApiListing");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private String getSwaggerFileName(String swaggerFileName) {
        return swaggerFileName == null || "".equals(swaggerFileName.trim()) ? "swagger" : swaggerFileName;
    }

    private String getSwaggerDirectoryName(String swaggerDirectory) {
        return new File(swaggerDirectory).getName();
    }

    private void configureObjectMapperFeatures(List<String> features, boolean enabled) throws Exception {
        for (String feature : features) {
            int i = feature.lastIndexOf(".");
            Class<?> clazz = Class.forName(feature.substring(0, i));
            Object e = Enum.valueOf(clazz, feature.substring(i + 1));
            this.getLog().debug((CharSequence)("enabling " + ((Enum)e).getDeclaringClass().toString() + "." + ((Enum)e).name() + ""));
            Method method = Json.mapper().getClass().getMethod("configure", e.getClass(), Boolean.TYPE);
            method.invoke((Object)Json.mapper(), e, enabled);
        }
    }
}

