/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.util;

import com.google.common.base.CharMatcher;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.annotation.RequestMapping;

public class SpringUtils {
    public static String createResourceKey(String resourceName, String version) {
        String resourceKey = !version.isEmpty() ? resourceName + "." + version : resourceName;
        resourceKey = CharMatcher.anyOf((CharSequence)"%^#?:;").removeFrom((CharSequence)resourceKey);
        return resourceKey;
    }

    public static String parseVersion(String mapping) {
        String[] mappingArray;
        String version = "";
        block0: for (String str : mappingArray = mapping.split("/")) {
            if (str.length() >= 4) continue;
            for (char c : str.toCharArray()) {
                if (!Character.isDigit(c)) continue;
                version = str;
                continue block0;
            }
        }
        return version;
    }

    public static String[] getControllerResquestMapping(Class<?> controllerClazz) {
        String[] controllerRequestMappingValues = new String[]{};
        RequestMapping classRequestMapping = (RequestMapping)AnnotationUtils.findAnnotation(controllerClazz, RequestMapping.class);
        if (classRequestMapping != null) {
            controllerRequestMappingValues = classRequestMapping.value();
        }
        if (controllerRequestMappingValues.length == 0) {
            controllerRequestMappingValues = new String[]{""};
        }
        return controllerRequestMappingValues;
    }
}

