/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.reader;

import com.github.kongchen.swagger.docgen.reader.AbstractReader;
import com.github.kongchen.swagger.docgen.reader.ClassSwaggerReader;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import io.swagger.converter.ModelConverters;
import io.swagger.jaxrs.PATCH;
import io.swagger.jaxrs.ext.SwaggerExtension;
import io.swagger.jaxrs.ext.SwaggerExtensions;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.SecurityRequirement;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.maven.plugin.logging.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;

public class JaxrsReader
extends AbstractReader
implements ClassSwaggerReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(JaxrsReader.class);

    public JaxrsReader(Swagger swagger, Log LOG) {
        super(swagger, LOG);
    }

    @Override
    public Swagger read(Set<Class<?>> classes) {
        for (Class<?> cls : classes) {
            this.read(cls);
        }
        return this.swagger;
    }

    public Swagger getSwagger() {
        return this.swagger;
    }

    public Swagger read(Class cls) {
        return this.read(cls, "", null, false, new String[0], new String[0], new HashMap<String, Tag>(), new ArrayList<Parameter>());
    }

    protected Swagger read(Class<?> cls, String parentPath, String parentMethod, boolean readHidden, String[] parentConsumes, String[] parentProduces, Map<String, Tag> parentTags, List<Parameter> parentParameters) {
        if (this.swagger == null) {
            this.swagger = new Swagger();
        }
        Api api = (Api)AnnotationUtils.findAnnotation(cls, Api.class);
        Path apiPath = (Path)AnnotationUtils.findAnnotation(cls, Path.class);
        if (!this.canReadApi(readHidden, api)) {
            return this.swagger;
        }
        Map<String, Tag> tags = this.updateTagsForApi(parentTags, api);
        List<SecurityRequirement> securities = this.getSecurityRequirements(api);
        for (Method method : cls.getMethods()) {
            Produces produces;
            Path methodPath;
            String operationPath;
            ApiOperation apiOperation = (ApiOperation)AnnotationUtils.findAnnotation((Method)method, ApiOperation.class);
            if (apiOperation == null || apiOperation.hidden() || (operationPath = this.getPath(apiPath, methodPath = (Path)AnnotationUtils.findAnnotation((Method)method, Path.class), parentPath)) == null) continue;
            HashMap<String, String> regexMap = new HashMap<String, String>();
            operationPath = this.parseOperationPath(operationPath, regexMap);
            String httpMethod = this.extractOperationMethod(apiOperation, method, SwaggerExtensions.chain());
            Operation operation = this.parseMethod(method);
            this.updateOperationParameters(parentParameters, regexMap, operation);
            this.updateOperationProtocols(apiOperation, operation);
            String[] apiConsumes = new String[]{};
            String[] apiProduces = new String[]{};
            Consumes consumes = (Consumes)AnnotationUtils.getAnnotation(cls, Consumes.class);
            if (consumes != null) {
                apiConsumes = consumes.value();
            }
            if ((produces = (Produces)AnnotationUtils.getAnnotation(cls, Produces.class)) != null) {
                apiProduces = produces.value();
            }
            apiConsumes = this.updateOperationConsumes(parentConsumes, apiConsumes, operation);
            apiProduces = this.updateOperationProduces(parentProduces, apiProduces, operation);
            this.handleSubResource(apiConsumes, httpMethod, apiProduces, tags, method, operationPath, operation);
            httpMethod = httpMethod == null ? parentMethod : httpMethod;
            this.updateTagsForOperation(operation, apiOperation);
            this.updateOperation(apiConsumes, apiProduces, tags, securities, operation);
            this.updatePath(operationPath, httpMethod, operation);
        }
        return this.swagger;
    }

    private void handleSubResource(String[] apiConsumes, String httpMethod, String[] apiProduces, Map<String, Tag> tags, Method method, String operationPath, Operation operation) {
        if (this.isSubResource(method)) {
            Class<?> responseClass = method.getReturnType();
            Swagger subSwagger = this.read(responseClass, operationPath, httpMethod, true, apiConsumes, apiProduces, tags, operation.getParameters());
        }
    }

    protected boolean isSubResource(Method method) {
        Class<?> responseClass = method.getReturnType();
        return responseClass != null && AnnotationUtils.findAnnotation(responseClass, Api.class) != null;
    }

    private String getPath(Path classLevelPath, Path methodLevelPath, String parentPath) {
        String output;
        if (classLevelPath == null && methodLevelPath == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (parentPath != null && !parentPath.isEmpty() && !parentPath.equals("/")) {
            if (!parentPath.startsWith("/")) {
                parentPath = "/" + parentPath;
            }
            if (parentPath.endsWith("/")) {
                parentPath = parentPath.substring(0, parentPath.length() - 1);
            }
            stringBuilder.append(parentPath);
        }
        if (classLevelPath != null) {
            stringBuilder.append(classLevelPath.value());
        }
        if (methodLevelPath != null && !methodLevelPath.value().equals("/")) {
            String methodPath = methodLevelPath.value();
            if (!methodPath.startsWith("/") && !stringBuilder.toString().endsWith("/")) {
                stringBuilder.append("/");
            }
            if (methodPath.endsWith("/")) {
                methodPath = methodPath.substring(0, methodPath.length() - 1);
            }
            stringBuilder.append(methodPath);
        }
        if (!(output = stringBuilder.toString()).startsWith("/")) {
            output = "/" + output;
        }
        if (output.endsWith("/") && output.length() > 1) {
            return output.substring(0, output.length() - 1);
        }
        return output;
    }

    public Operation parseMethod(Method method) {
        ApiResponses apiResponses;
        Produces produces;
        Consumes consumes;
        Operation operation = new Operation();
        ApiOperation apiOperation = (ApiOperation)AnnotationUtils.findAnnotation((Method)method, ApiOperation.class);
        String operationId = method.getName();
        String responseContainer = null;
        Class responseClass = null;
        Map<String, Property> defaultResponseHeaders = null;
        if (apiOperation != null) {
            if (apiOperation.hidden()) {
                return null;
            }
            if (!apiOperation.nickname().isEmpty()) {
                operationId = apiOperation.nickname();
            }
            defaultResponseHeaders = this.parseResponseHeaders(apiOperation.responseHeaders());
            operation.summary(apiOperation.value()).description(apiOperation.notes());
            Set<Map<String, Object>> customExtensions = this.parseCustomExtensions(apiOperation.extensions());
            if (customExtensions != null) {
                for (Map<String, Object> map : customExtensions) {
                    if (map == null) continue;
                    for (Map.Entry<String, Object> map2 : map.entrySet()) {
                        operation.setVendorExtension(map2.getKey().startsWith("x-") ? map2.getKey() : "x-" + map2.getKey(), map2.getValue());
                    }
                }
            }
            if (!apiOperation.response().equals(Void.class)) {
                responseClass = apiOperation.response();
            }
            if (!apiOperation.responseContainer().isEmpty()) {
                responseContainer = apiOperation.responseContainer();
            }
            ArrayList<SecurityRequirement> securities = new ArrayList<SecurityRequirement>();
            for (Authorization auth : apiOperation.authorizations()) {
                if (auth.value().isEmpty()) continue;
                SecurityRequirement security = new SecurityRequirement();
                security.setName(auth.value());
                for (AuthorizationScope scope : auth.scopes()) {
                    if (scope.scope().isEmpty()) continue;
                    security.addScope(scope.scope());
                }
                securities.add(security);
            }
            for (SecurityRequirement sec : securities) {
                operation.security(sec);
            }
        }
        operation.operationId(operationId);
        if (responseClass == null) {
            LOGGER.debug("picking up response class from method " + method);
            Type t = method.getGenericReturnType();
            responseClass = method.getReturnType();
            if (!responseClass.equals(Void.class) && !responseClass.equals(Void.TYPE) && AnnotationUtils.findAnnotation(responseClass, Api.class) == null) {
                LOGGER.debug("reading model " + responseClass);
                Map models = ModelConverters.getInstance().readAll(t);
            }
        }
        if (responseClass != null && !responseClass.equals(Void.class) && !responseClass.equals(Response.class) && AnnotationUtils.findAnnotation((Class)responseClass, Api.class) == null) {
            if (this.isPrimitive(responseClass)) {
                Property property = ModelConverters.getInstance().readAsProperty(responseClass);
                if (property != null) {
                    Object responseProperty = "list".equalsIgnoreCase(responseContainer) ? new ArrayProperty(property) : ("map".equalsIgnoreCase(responseContainer) ? new MapProperty(property) : property);
                    operation.response(apiOperation.code(), new io.swagger.models.Response().description("successful operation").schema((Property)responseProperty).headers(defaultResponseHeaders));
                }
            } else if (!responseClass.equals(Void.class) && !responseClass.equals(Void.TYPE)) {
                Map models = ModelConverters.getInstance().read((Type)responseClass);
                if (models.isEmpty()) {
                    Property p = ModelConverters.getInstance().readAsProperty((Type)responseClass);
                    operation.response(apiOperation.code(), new io.swagger.models.Response().description("successful operation").schema(p).headers(defaultResponseHeaders));
                }
                for (String string : models.keySet()) {
                    Object responseProperty = "list".equalsIgnoreCase(responseContainer) ? new ArrayProperty((Property)new RefProperty().asDefault(string)) : ("map".equalsIgnoreCase(responseContainer) ? new MapProperty((Property)new RefProperty().asDefault(string)) : new RefProperty().asDefault(string));
                    operation.response(apiOperation.code(), new io.swagger.models.Response().description("successful operation").schema((Property)responseProperty).headers(defaultResponseHeaders));
                    this.swagger.model(string, (Model)models.get(string));
                }
                models = ModelConverters.getInstance().readAll((Type)responseClass);
                for (Map.Entry entry : models.entrySet()) {
                    this.swagger.model((String)entry.getKey(), (Model)entry.getValue());
                }
            }
        }
        if ((consumes = (Consumes)AnnotationUtils.findAnnotation((Method)method, Consumes.class)) != null) {
            for (String mediaType : consumes.value()) {
                operation.consumes(mediaType);
            }
        }
        if ((produces = (Produces)AnnotationUtils.findAnnotation((Method)method, Produces.class)) != null) {
            for (String mediaType : produces.value()) {
                operation.produces(mediaType);
            }
        }
        if ((apiResponses = (ApiResponses)AnnotationUtils.findAnnotation((Method)method, ApiResponses.class)) != null) {
            this.updateApiResponse(operation, apiResponses);
        }
        if (AnnotationUtils.findAnnotation((Method)method, Deprecated.class) != null) {
            operation.deprecated(Boolean.valueOf(true));
        }
        boolean hidden = false;
        if (apiOperation != null) {
            hidden = apiOperation.hidden();
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Type type = genericParameterTypes[i];
            List<Annotation> annotations = Arrays.asList(paramAnnotations[i]);
            List<Parameter> parameters = this.getParameters(type, annotations);
            for (Parameter parameter : parameters) {
                operation.parameter(parameter);
            }
        }
        if (operation.getResponses() == null) {
            operation.defaultResponse(new io.swagger.models.Response().description("successful operation"));
        }
        this.readImplicitParameters(method, operation);
        return operation;
    }

    public String extractOperationMethod(ApiOperation apiOperation, Method method, Iterator<SwaggerExtension> chain) {
        if (!apiOperation.httpMethod().isEmpty()) {
            return apiOperation.httpMethod().toLowerCase();
        }
        if (AnnotationUtils.findAnnotation((Method)method, GET.class) != null) {
            return "get";
        }
        if (AnnotationUtils.findAnnotation((Method)method, PUT.class) != null) {
            return "put";
        }
        if (AnnotationUtils.findAnnotation((Method)method, POST.class) != null) {
            return "post";
        }
        if (AnnotationUtils.findAnnotation((Method)method, DELETE.class) != null) {
            return "delete";
        }
        if (AnnotationUtils.findAnnotation((Method)method, OPTIONS.class) != null) {
            return "options";
        }
        if (AnnotationUtils.findAnnotation((Method)method, HEAD.class) != null) {
            return "head";
        }
        if (AnnotationUtils.findAnnotation((Method)method, PATCH.class) != null) {
            return "patch";
        }
        for (Annotation declaredAnnotation : method.getDeclaredAnnotations()) {
            Annotation[] innerAnnotations;
            for (Annotation innerAnnotation : innerAnnotations = declaredAnnotation.annotationType().getAnnotations()) {
                if (!(innerAnnotation instanceof HttpMethod)) continue;
                HttpMethod httpMethod = (HttpMethod)innerAnnotation;
                return httpMethod.value().toLowerCase();
            }
        }
        if (chain.hasNext()) {
            return chain.next().extractOperationMethod(apiOperation, method, chain);
        }
        return null;
    }
}

