/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.mavenplugin;

import com.github.kongchen.swagger.docgen.AbstractDocumentSource;
import com.github.kongchen.swagger.docgen.GenerateException;
import com.github.kongchen.swagger.docgen.LogAdapter;
import com.github.kongchen.swagger.docgen.mavenplugin.ApiSource;
import com.github.kongchen.swagger.docgen.mavenplugin.SecurityDefinition;
import com.github.kongchen.swagger.docgen.reader.ClassSwaggerReader;
import com.github.kongchen.swagger.docgen.reader.JaxrsReader;
import io.swagger.config.FilterFactory;
import io.swagger.core.filter.SpecFilter;
import io.swagger.core.filter.SwaggerSpecFilter;
import io.swagger.models.auth.SecuritySchemeDefinition;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public class MavenDocumentSource
extends AbstractDocumentSource {
    private final SpecFilter specFilter = new SpecFilter();

    public MavenDocumentSource(ApiSource apiSource, Log log) throws MojoFailureException {
        super(new LogAdapter(log), apiSource);
    }

    @Override
    public void loadDocuments() throws GenerateException {
        Map defs;
        if (this.apiSource.getSwaggerInternalFilter() != null) {
            try {
                this.LOG.info("Setting filter configuration: " + this.apiSource.getSwaggerInternalFilter());
                FilterFactory.setFilter((SwaggerSpecFilter)((SwaggerSpecFilter)Class.forName(this.apiSource.getSwaggerInternalFilter()).newInstance()));
            }
            catch (Exception e) {
                throw new GenerateException("Cannot load: " + this.apiSource.getSwaggerInternalFilter(), e);
            }
        }
        this.swagger = this.resolveApiReader().read(this.apiSource.getValidClasses());
        if (this.apiSource.getSecurityDefinitions() != null) {
            for (SecurityDefinition sd : this.apiSource.getSecurityDefinitions()) {
                if (sd.getDefinitions().isEmpty()) continue;
                for (Map.Entry<String, SecuritySchemeDefinition> entry : sd.getDefinitions().entrySet()) {
                    this.swagger.addSecurityDefinition(entry.getKey(), entry.getValue());
                }
            }
        }
        if ((defs = this.swagger.getSecurityDefinitions()) != null) {
            TreeMap sortedDefs = new TreeMap();
            sortedDefs.putAll(defs);
            this.swagger.setSecurityDefinitions(sortedDefs);
        }
        if (FilterFactory.getFilter() != null) {
            this.swagger = new SpecFilter().filter(this.swagger, FilterFactory.getFilter(), new HashMap(), new HashMap(), new HashMap());
        }
    }

    private ClassSwaggerReader resolveApiReader() throws GenerateException {
        String customReaderClassName = this.apiSource.getSwaggerApiReader();
        if (customReaderClassName == null) {
            JaxrsReader reader = new JaxrsReader(this.swagger, this.LOG);
            reader.setTypesToSkip(this.typesToSkip);
            return reader;
        }
        return this.getCustomApiReader(customReaderClassName);
    }
}

