/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.remote;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.github.kongchen.swagger.docgen.AbstractDocumentSource;
import com.github.kongchen.swagger.docgen.LogAdapter;
import com.wordnik.swagger.core.Documentation;
import com.wordnik.swagger.core.DocumentationEndPoint;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;

public class RemoteDocumentSource
extends AbstractDocumentSource {
    private final LogAdapter LOG;
    private final URI requestURI;
    ObjectMapper mapper = new ObjectMapper();
    private boolean withFormatSuffix = true;

    public RemoteDocumentSource(LogAdapter logAdapter, URI requestURI, String outputTpl, String outputPath, String swaggerOutput) {
        super(logAdapter, outputPath, outputTpl, swaggerOutput);
        this.LOG = new LogAdapter(Logger.getLogger(RemoteDocumentSource.class));
        this.requestURI = requestURI;
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);
        this.mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public void loadDocuments() throws IOException {
        Documentation doc;
        DefaultHttpClient client = new DefaultHttpClient();
        HttpResponse response = client.execute((HttpUriRequest)new HttpGet(this.requestURI));
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new IOException(this.requestURI + " got " + response.getStatusLine().getReasonPhrase());
        }
        this.serviceDocument = doc = (Documentation)this.mapper.readValue(response.getEntity().getContent(), Documentation.class);
        this.setApiVersion(doc.getApiVersion());
        this.setBasePath(doc.getBasePath());
        URIBuilder uriBuilder = new URIBuilder(this.requestURI);
        String path = uriBuilder.getPath();
        for (DocumentationEndPoint endPoint : doc.getApis()) {
            String _endpoint = endPoint.getPath().replaceAll("/api-docs\\.\\{format\\}", "");
            uriBuilder.setPath((path + "/" + _endpoint).replaceAll("\\/\\/", "/"));
            String newURL = null;
            try {
                newURL = uriBuilder.build().toString();
            }
            catch (URISyntaxException e) {
                this.LOG.error("URL " + newURL + "is not valid.");
                continue;
            }
            this.LOG.info("calling " + newURL);
            response = client.execute((HttpUriRequest)new HttpGet(newURL));
            Documentation _doc = (Documentation)this.mapper.readValue(response.getEntity().getContent(), Documentation.class);
            if (!this.withFormatSuffix) {
                for (DocumentationEndPoint ep : _doc.getApis()) {
                    ep.setPath(ep.getPath().replaceAll("\\.\\{format}", ""));
                }
            }
            this.acceptDocument(_doc);
        }
    }

    public void withFormatSuffix(boolean with) {
        this.withFormatSuffix = with;
    }
}

