/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.mustache;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsonschema.JsonSchema;
import com.github.kongchen.swagger.docgen.AbstractDocumentSource;
import com.github.kongchen.swagger.docgen.TypeUtils;
import com.github.kongchen.swagger.docgen.mustache.MustacheApi;
import com.github.kongchen.swagger.docgen.mustache.MustacheDataType;
import com.github.kongchen.swagger.docgen.mustache.MustacheDocument;
import com.github.kongchen.swagger.docgen.mustache.MustacheItem;
import com.github.kongchen.swagger.docgen.mustache.MustacheOperation;
import com.github.kongchen.swagger.docgen.mustache.MustacheResponseClass;
import com.wordnik.swagger.core.Documentation;
import com.wordnik.swagger.core.DocumentationEndPoint;
import com.wordnik.swagger.core.DocumentationOperation;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class OutputTemplate {
    private String basePath;
    private String apiVersion;
    private Set<MustacheDocument> apiDocuments = new LinkedHashSet<MustacheDocument>();
    private Set<MustacheDataType> dataTypes = new LinkedHashSet<MustacheDataType>();

    public OutputTemplate(AbstractDocumentSource docSource) {
        this.feedSource(docSource);
    }

    public static String getJsonSchema() {
        ObjectMapper m = new ObjectMapper();
        try {
            JsonSchema js = m.generateJsonSchema(OutputTemplate.class);
            return m.writeValueAsString((Object)js);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Set<MustacheDataType> getDataTypes() {
        return this.dataTypes;
    }

    public void addDateType(MustacheDocument mustacheDocument, MustacheDataType dataType) {
        this.dataTypes.add(dataType);
        for (MustacheItem item : dataType.getItems()) {
            String trueType = TypeUtils.getTrueType(item.getType());
            if (trueType == null) continue;
            this.addDateType(mustacheDocument, new MustacheDataType(mustacheDocument, trueType));
        }
    }

    public Set<MustacheDocument> getApiDocuments() {
        return this.apiDocuments;
    }

    public void setApiDocuments(Set<MustacheDocument> apiDocuments) {
        this.apiDocuments = apiDocuments;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    private MustacheDocument createMustacheDocument(Documentation swaggerDoc) {
        MustacheDocument mustacheDocument = new MustacheDocument(swaggerDoc);
        for (DocumentationEndPoint api : swaggerDoc.getApis()) {
            mustacheDocument.setDescription(api.getDescription());
            MustacheApi mustacheApi = new MustacheApi(swaggerDoc.getBasePath(), api);
            for (DocumentationOperation op : api.getOperations()) {
                MustacheOperation mustacheOperation = new MustacheOperation(mustacheDocument, op);
                mustacheApi.addOperation(mustacheOperation);
                this.addResponseType(mustacheDocument, mustacheOperation.getResponseClass());
            }
            mustacheDocument.addApi(mustacheApi);
        }
        for (String requestType : mustacheDocument.getRequestTypes()) {
            MustacheDataType dataType = new MustacheDataType(mustacheDocument, requestType);
            this.addDateType(mustacheDocument, dataType);
        }
        LinkedHashSet<String> missedTypes = new LinkedHashSet<String>();
        for (String responseType : mustacheDocument.getResponseTypes()) {
            String ttype;
            if (mustacheDocument.getRequestTypes().contains(responseType) || (ttype = TypeUtils.getTrueType(responseType)) == null) continue;
            missedTypes.add(ttype);
        }
        for (String type : missedTypes) {
            MustacheDataType dataType = new MustacheDataType(mustacheDocument, type);
            this.addDateType(mustacheDocument, dataType);
        }
        this.filterDatatypes(this.dataTypes);
        return mustacheDocument;
    }

    private void filterDatatypes(Set<MustacheDataType> dataTypes) {
        Iterator<MustacheDataType> it = dataTypes.iterator();
        while (it.hasNext()) {
            MustacheDataType type = it.next();
            if (type.items != null && type.items.size() != 0) continue;
            it.remove();
        }
    }

    private void addResponseType(MustacheDocument mustacheDocument, MustacheResponseClass responseClass) {
        mustacheDocument.addResponseType(responseClass.getClassLinkName());
        if (responseClass.getGenericClasses() != null) {
            for (MustacheResponseClass mrc : responseClass.getGenericClasses()) {
                this.addResponseType(mustacheDocument, mrc);
            }
        }
    }

    private void feedSource(AbstractDocumentSource source) {
        for (Documentation doc : source.getValidDocuments()) {
            if (doc.getApis() == null) continue;
            MustacheDocument mustacheDocument = this.createMustacheDocument(doc);
            this.addMustacheDocument(mustacheDocument);
        }
        this.setBasePath(source.getBasePath());
        this.setApiVersion(source.getApiVersion());
    }

    private void addMustacheDocument(MustacheDocument mustacheDocument) {
        mustacheDocument.setIndex(this.apiDocuments.size() + 1);
        this.apiDocuments.add(mustacheDocument);
    }

    public void setDataTypes(Set<MustacheDataType> dataTypes) {
        this.dataTypes = dataTypes;
    }
}

