/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.mustache;

import com.github.kongchen.swagger.docgen.mustache.MustacheDocument;
import com.github.kongchen.swagger.docgen.mustache.MustacheParameterSet;
import com.github.kongchen.swagger.docgen.mustache.MustacheResponseClass;
import com.github.kongchen.swagger.docgen.mustache.MustacheSample;
import com.wordnik.swagger.core.DocumentationError;
import com.wordnik.swagger.core.DocumentationOperation;
import java.util.List;

public class MustacheOperation {
    int opIndex;
    String httpMethod;
    String summary;
    String notes;
    MustacheResponseClass responseClass;
    String nickname;
    List<MustacheParameterSet> parameters;
    MustacheParameterSet requestQuery;
    MustacheParameterSet requestHeader;
    MustacheParameterSet requestBody;
    MustacheParameterSet requestPath;
    MustacheParameterSet responseHeader;
    List<DocumentationError> errorResponses;
    List<MustacheSample> samples;

    public MustacheOperation(MustacheDocument mustacheDocument, DocumentationOperation op) {
        this.httpMethod = op.getHttpMethod();
        this.notes = op.getNotes();
        this.summary = op.getSummary();
        this.nickname = op.nickname();
        this.parameters = mustacheDocument.analyzeParameters(op.getParameters());
        this.responseClass = new MustacheResponseClass(op.getResponseClass());
        this.errorResponses = op.getErrorResponses();
        if (this.parameters == null) {
            return;
        }
        for (MustacheParameterSet para : this.parameters) {
            if (para.getParamType().equals("query")) {
                this.requestQuery = para;
                continue;
            }
            if (para.getParamType().equals("header")) {
                this.requestHeader = para;
                continue;
            }
            if (para.getParamType().equals("body")) {
                this.requestBody = para;
                continue;
            }
            if (para.getParamType().equals("path")) {
                this.requestPath = para;
                continue;
            }
            if (!para.getParamType().equals("response_header")) continue;
            this.responseHeader = para;
        }
    }

    public MustacheParameterSet getResponseHeader() {
        return this.responseHeader;
    }

    public void setResponseHeader(MustacheParameterSet responseHeader) {
        this.responseHeader = responseHeader;
    }

    public MustacheParameterSet getRequestPath() {
        return this.requestPath;
    }

    public void setRequestPath(MustacheParameterSet requestPath) {
        this.requestPath = requestPath;
    }

    public MustacheParameterSet getRequestQuery() {
        return this.requestQuery;
    }

    public void setRequestQuery(MustacheParameterSet requestQuery) {
        this.requestQuery = requestQuery;
    }

    public MustacheParameterSet getRequestHeader() {
        return this.requestHeader;
    }

    public void setRequestHeader(MustacheParameterSet requestHeader) {
        this.requestHeader = requestHeader;
    }

    public MustacheParameterSet getRequestBody() {
        return this.requestBody;
    }

    public void setRequestBody(MustacheParameterSet requestBody) {
        this.requestBody = requestBody;
    }

    public List<MustacheSample> getSamples() {
        return this.samples;
    }

    public void setSamples(List<MustacheSample> samples) {
        this.samples = samples;
    }

    public int getOpIndex() {
        return this.opIndex;
    }

    public void setOpIndex(int opIndex) {
        this.opIndex = opIndex;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public List<MustacheParameterSet> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<MustacheParameterSet> parameters) {
        this.parameters = parameters;
    }

    public List<DocumentationError> getErrorResponses() {
        return this.errorResponses;
    }

    public void setErrorResponses(List<DocumentationError> errorResponses) {
        this.errorResponses = errorResponses;
    }

    public MustacheResponseClass getResponseClass() {
        return this.responseClass;
    }

    public void setResponseClass(MustacheResponseClass responseClass) {
        this.responseClass = responseClass;
    }
}

