/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.kongchen.swagger.docgen.GenerateException;
import com.github.kongchen.swagger.docgen.LogAdapter;
import com.github.kongchen.swagger.docgen.mustache.OutputTemplate;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.wordnik.swagger.core.Documentation;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;

public abstract class AbstractDocumentSource {
    protected final LogAdapter LOG;
    private final String outputPath;
    private final String templatePath;
    private final String swaggerPath;
    protected Documentation serviceDocument;
    List<Documentation> validDocuments = new LinkedList<Documentation>();
    private String basePath;
    private String apiVersion;
    private ObjectMapper mapper = new ObjectMapper();
    private OutputTemplate outputTemplate;

    public AbstractDocumentSource(LogAdapter logAdapter, String outputPath, String outputTpl, String swaggerOutput) {
        this.LOG = logAdapter;
        this.outputPath = outputPath;
        this.templatePath = outputTpl;
        this.swaggerPath = swaggerOutput;
    }

    public abstract void loadDocuments() throws Exception, GenerateException;

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public OutputTemplate getOutputTemplate() {
        return this.outputTemplate;
    }

    protected void acceptDocument(Documentation doc) {
        this.validDocuments.add(doc);
    }

    public List<Documentation> getValidDocuments() {
        return this.validDocuments;
    }

    public void toSwaggerDocuments() throws GenerateException {
        if (this.swaggerPath == null) {
            return;
        }
        File dir = new File(this.swaggerPath);
        if (dir.isFile()) {
            throw new GenerateException(String.format("Swagger-outputDirectory[%s] must be a directory!", this.swaggerPath));
        }
        if (!dir.exists()) {
            try {
                FileUtils.forceMkdir((File)dir);
            }
            catch (IOException e) {
                throw new GenerateException(String.format("Create Swagger-outputDirectory[%s] failed.", this.swaggerPath));
            }
        }
        this.cleanupOlds(dir);
        this.writeInDirectory(dir, this.serviceDocument);
        for (Documentation doc : this.validDocuments) {
            this.writeInDirectory(dir, doc);
        }
    }

    private void cleanupOlds(File dir) {
        if (dir.listFiles() != null) {
            for (File f : dir.listFiles()) {
                if (!f.getName().endsWith("json")) continue;
                f.delete();
            }
        }
    }

    private String resourcePathToFilename(String resourcePath) {
        if (resourcePath == null) {
            return "service.json";
        }
        String name = resourcePath;
        if (resourcePath.startsWith("/")) {
            name = resourcePath.substring(1);
        }
        name = name.replaceAll("/", "_");
        return name + ".json";
    }

    private void writeInDirectory(File dir, Documentation doc) throws GenerateException {
        String filename = this.resourcePathToFilename(doc.getResourcePath());
        File serviceFile = new File(dir, filename);
        try {
            while (!serviceFile.createNewFile()) {
                serviceFile.delete();
            }
            this.mapper.writerWithDefaultPrettyPrinter().writeValue(serviceFile, (Object)doc);
        }
        catch (IOException e) {
            throw new GenerateException(e);
        }
    }

    public OutputTemplate prepareMustacheTemplate() {
        this.outputTemplate = new OutputTemplate(this);
        return this.outputTemplate;
    }

    public void toDocuments() throws GenerateException {
        if (this.outputTemplate == null) {
            this.prepareMustacheTemplate();
        }
        if (this.outputTemplate.getApiDocuments().isEmpty()) {
            this.LOG.warn("nothing to write.");
            return;
        }
        this.LOG.info("Writing doc to " + this.outputPath + "...");
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.outputPath);
        }
        catch (FileNotFoundException e) {
            throw new GenerateException(e);
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutputStream, Charset.forName("UTF-8"));
        DefaultMustacheFactory mf = new DefaultMustacheFactory();
        URI uri = null;
        try {
            uri = new URI(this.templatePath);
        }
        catch (URISyntaxException e) {
            throw new GenerateException(e);
        }
        if (!uri.isAbsolute()) {
            File file = new File(this.templatePath);
            if (!file.exists()) {
                throw new GenerateException("Template " + file.getAbsoluteFile() + " not found. You can go to https://github.com/kongchen/api-doc-template to get templates.");
            }
            uri = new File(this.templatePath).toURI();
        }
        URL url = null;
        try {
            url = uri.toURL();
            InputStreamReader reader = new InputStreamReader(url.openStream(), Charset.forName("UTF-8"));
            Mustache mustache = mf.compile((Reader)reader, this.templatePath);
            mustache.execute((Writer)writer, (Object)this.outputTemplate).flush();
            writer.close();
            this.LOG.info("Done!");
        }
        catch (MalformedURLException e) {
            throw new GenerateException(e);
        }
        catch (IOException e) {
            throw new GenerateException(e);
        }
    }
}

