package com.github.kondaurovdev.json_generic

import play.api.libs.json.{JsSuccess, _}

sealed trait iSerializedGenericCase[T <: iGenericCase] {

  def genericDef: iGenericDef[_]

  def genericCaseName: String

  def castReads: Reads[T]

  def jsonWrites: Writes[T]

}

trait iEmptyGenericCase[T <: iGenericCase] extends iSerializedGenericCase[T] {

  def getEmptyGenericCaseInstance: T

  def getJsonReads: Reads[T] = (json: JsValue) => JsSuccess(getEmptyGenericCaseInstance)

  def getJsonWrites: Writes[T] = (o: T) => {
    JsString(o.genericName)
  }

}

class EmptyGenericCase[T <: iGenericCase](
                                         val genericCaseName: String,
                                         inst: => T,
                                         val genericDef: iGenericDef[_]) extends iEmptyGenericCase[T] {

  def getEmptyGenericCaseInstance: T = inst

  val castReads: Reads[T] = getJsonReads

  val jsonWrites: Writes[T] = getJsonWrites

}

trait iNonEmptyGenericCase[T <: iGenericCase] extends iSerializedGenericCase[T] {

  def genericCaseFormat: Format[T]

  def castReads: Reads[T] = genericCaseFormat

  def jsonWrites: Writes[T] = (o: T) => Json.obj(genericCaseName -> Json.toJson(o)(genericCaseFormat))

}

class NonEmptyGenericCase[T <: iGenericCase](
                                            val genericCaseName: String,
                                            val genericCaseFormat: Format[T],
                                            val genericDef: iGenericDef[_]) extends iNonEmptyGenericCase[T]

