package com.github.kondaurovdev.json_generic

import play.api.libs.json._
import com.github.kondaurovdev.play_json.helper.{iEitherHelper, iValidateHelper}

trait iGenericDef[R <: iGenericCase] {

  def eitherHelper: iEitherHelper
  def validateHelper: iValidateHelper
  def all: Stream[iSerializedGenericCase[_ <: R]]

  def findGeneric(json: JsValue): Either[JsValue, (iSerializedGenericCase[_ <: R], JsValue)] = {
    for (
      m <- validateHelper.validate[GenericValue](json).right;
      task <- findGeneric(m.name).right
    ) yield task -> m.body
  }

  def findGeneric(genericName: String): Either[JsValue, iSerializedGenericCase[_ <: R]] = {

    all
      .find(_.genericCaseName.equalsIgnoreCase(genericName))
      .toRight({
        Json.obj(
          "error" -> s"Can't find '$genericName'",
          "available" -> all.map(_.genericCaseName)
        )
      })

  }

  def getJsonReads: Reads[R] = {
    val cn = this.getClass.getSimpleName
    (json: JsValue) => {
      eitherHelper.toJsResult {
        (for {
          task <- findGeneric(json)
          res <- validateHelper.validate(task._2)(task._1.castReads)
        } yield res).left.map(err => Json.obj(s"Can't read generic '$cn'" -> err))
      }
    }
  }

  def getJsonWrites: Writes[R] = {
    (o: R) => {
      {
        eitherHelper.toJsValue {
          for {
            task <- findGeneric(o.genericName)
          } yield Json.toJson(o)(task.jsonWrites.asInstanceOf[Writes[R]])
        }(successObj = false, errorObj = false)
      }
    }
  }

  def nonEmptyGeneric[C <: R](name: String, format: Format[C]): NonEmptyGenericCase[C] = {
    new NonEmptyGenericCase(name, format, this)
  }

  def emptyGeneric[C <: R](name: String, inst: => C): EmptyGenericCase[C] = {
    new EmptyGenericCase(name, inst, this)
  }

}

abstract class GenericDef[R <: iGenericCase](
                                             val validateHelper: iValidateHelper,
                                             val eitherHelper: iEitherHelper
                                             ) extends iGenericDef[R] {

  implicit lazy val genericFormat = Format(getJsonReads, getJsonWrites)

}
