package com.github.kondaurovdev.json_generic

import play.api.libs.json._

object GenericValue {

  implicit val jsonReads: Reads[GenericValue] = {
    case JsString(s) => JsSuccess(GenericValue(s, Json.obj()))
    case obj: JsObject =>

      obj.fields.length match {
        case 0 => JsError(s"Object is empty")
        case 1 => val head = obj.fields.head; JsSuccess(GenericValue(head._1, head._2))
        case _ => JsError(s"Object has too many fields (${obj.fields.map(_._1).mkString(",")})")
      }

    case _ => JsError("JsObject or string expected")

  }

  implicit val jsonWrites: Writes[GenericValue] = (o: GenericValue) => {
    o.body match {
      case JsNull => JsString(o.name)
      case _ => Json.obj(o.name -> o.body)
    }
  }

}

case class GenericValue(
                        name: String,
                        body: JsValue)