package com.github.kondaurovdev.json_generic

import play.api.libs.json.{JsSuccess, _}

sealed trait iSerializedGeneric[T <: iGenericCase] {

  def genericName: String

  def castReads: Reads[T]

  def jsonWrites: Writes[T]

}

trait iEmptyGeneric[T <: iGenericCase] extends iSerializedGeneric[T] {

  def emptyGeneric(): T

  val castReads: Reads[T] = (json: JsValue) => JsSuccess(emptyGeneric())

  val jsonWrites: Writes[T] = (o: T) => {
    JsString(o.generic().genericName)
  }

}

trait iNonEmptyGeneric[T <: iGenericCase] extends iSerializedGeneric[T] {

  def genericFormat: Format[T]

  lazy val castReads: Reads[T] = genericFormat

  lazy val jsonWrites: Writes[T] = (o: T) => {

    o.generic() match {
      case g: iEmptyGeneric[_] => JsString(g.genericName)
      case g: iSerializedGeneric[_] =>
        Json.obj(
          g.genericName -> Json.toJson(o)(genericFormat)
        )
    }

  }

}