package com.github.kondaurovdev.json_generic

import com.github.kondaurovdev.json_generic.helpers.Validate
import play.api.libs.json._
import com.github.kondaurovdev.json_generic.helpers.Implicits._

trait iGeneric[R <: iGenericCase] {

  def all: Stream[iSerializedGeneric[_ <: R]]

  def findGeneric(json: JsValue): Either[JsValue, (iSerializedGeneric[_ <: R], JsValue)] = {
    for (
      m <- Validate.validate[GenericValue](json).right;
      task <- findGeneric(m.name).right
    ) yield task -> m.body
  }

  def findGeneric(genericName: String): Either[JsValue, iSerializedGeneric[_ <: R]] = {

    all
      .find(_.genericName.equalsIgnoreCase(genericName))
      .toRight({
        Json.obj(
          "error" -> s"Can't find '$genericName'",
          "available" -> all.map(_.genericName)
        )
      })
  }

  implicit lazy val genericFormat: Format[R] = Format({
    val cn = this.getClass.getSimpleName
    (json: JsValue) => {
      (for (
        task <- findGeneric(json).right;
        res <- Validate.validate(task._2)(task._1.castReads).right
      ) yield res).left.map(err => Json.obj(s"Can't read generic '$cn'" -> err)).toJsResult
    }
  }, {
    (o: R) => {
      {
        for (
          task <- findGeneric(o.generic().genericName).right
        ) yield {
          task match {
            case _ =>
              task.jsonWrites match {
                case writes: Writes[R] =>
                  val res = Json.toJson(o)(writes)
                  res
                case _ => JsString("error: can't find writes")
              }
          }

        }
      }.left.map(err => Json.obj("Writes error" -> err)).toJsValue(successObj = false, errorObj = false)
    }
  })

}
