package com.github.kondaurovdev.json_generic

import com.github.kondaurovdev.play_json.helper.ValidateHelper
import com.github.kondaurovdev.play_json.wrapper
import play.api.libs.json.{JsObject, JsValue, Writes}

package object helpers {

  object Implicits {

    implicit class EitherWrapper[L, R](e: Either[L, R])(implicit writesLeft: Writes[L]) extends wrapper.EitherWrapper[L, R](e)

    implicit class StringWrapper(s: String) extends wrapper.StringWrapper(s)

    implicit class JsValueWrapper(js: JsValue) extends wrapper.JsValueWrapper(js)

    implicit class JsObjectWrapper(js: JsObject) extends wrapper.JsObjectWrapper(js)

  }

  object Validate extends ValidateHelper

}
