package com.github.kondaurovdev.json_generic

import play.api.libs.json._

object GenericValue {

  implicit val jsonReads: Reads[GenericValue] = {
    case JsString(s) => JsSuccess(GenericValue(s, Json.obj()))
    case obj: JsObject =>

      obj.fields.length match {
        case 0 => JsError(s"Object is empty")
        case 1 =>
          obj.fields.headOption match {
            case Some(t) => JsSuccess(GenericValue(t._1, t._2))
            case None => JsError("Can't get first prop")
          }
        case num => JsError(s"Object has too many fields ($num)")
      }

    case _ => JsError("JsObject or string expected")

  }

  implicit val jsonWrites: Writes[GenericValue] = (o: GenericValue) => {
    o.body match {
      case JsNull => JsString(o.name)
      case _ => Json.obj(o.name -> o.body)
    }
  }

}

case class GenericValue(
                        name: String,
                        body: JsValue)