/*
 * Decompiled with CFR 0.152.
 */
package org.komputing.khash.sha256.extensions;

import kotlin.Metadata;
import kotlin.UByte;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.komputing.khash.sha256.extensions.ArrayExtensionsKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0015\n\u0000\u001a,\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0000\u001a\u001c\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\f\u0010\f\u001a\u00020\r*\u00020\u0002H\u0000\u00a8\u0006\u000e"}, d2={"copy", "", "", "srcPos", "", "dest", "destPos", "length", "putLong", "offset", "value", "", "toIntArray", "", "sha256"})
public final class ByteArrayExtensionsKt {
    public static final void putLong(@NotNull byte[] $this$putLong, int offset, long value) {
        Intrinsics.checkNotNullParameter((Object)$this$putLong, (String)"<this>");
        int n = 7;
        do {
            int i = n--;
            long l = value >>> i * 8;
            boolean bl = false;
            byte temp = UByte.constructor-impl((byte)((byte)l));
            boolean bl2 = false;
            $this$putLong[offset + 7 - i] = temp;
        } while (0 <= n);
    }

    @NotNull
    public static final int[] toIntArray(@NotNull byte[] $this$toIntArray) {
        Intrinsics.checkNotNullParameter((Object)$this$toIntArray, (String)"<this>");
        if ($this$toIntArray.length % 4 != 0) {
            throw new IllegalArgumentException("Byte array length must be a multiple of 4");
        }
        int n = 0;
        int[] array = new int[$this$toIntArray.length / 4];
        int n2 = array.length + -1;
        if (n <= n2) {
            do {
                int i = n++;
                Byte[] byteArray = new Byte[]{$this$toIntArray[i * 4], $this$toIntArray[i * 4 + 1], $this$toIntArray[i * 4 + 2], $this$toIntArray[i * 4 + 3]};
                Byte[] integer = byteArray;
                array[i] = ArrayExtensionsKt.toInt(integer);
            } while (n <= n2);
        }
        return array;
    }

    public static final void copy(@NotNull byte[] $this$copy, int srcPos, @NotNull byte[] dest, int destPos, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$copy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        ArraysKt.copyInto((byte[])$this$copy, (byte[])dest, (int)destPos, (int)srcPos, (int)(srcPos + length));
    }
}

