/*
 * Decompiled with CFR 0.152.
 */
package org.komputing.khash.sha256;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.komputing.khash.sha256.extensions.ByteArrayExtensionsKt;
import org.komputing.khash.sha256.extensions.IntArrayExtensionsKt;
import org.komputing.khash.sha256.extensions.IntExtensionsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J \u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J \u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u0015\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0015J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/komputing/khash/sha256/Sha256;", "", "()V", "H", "", "H0", "K", "TEMP", "W", "bigSig0", "", "x", "bigSig1", "ch", "y", "z", "digest", "", "message", "maj", "padMessage", "padMessage$sha256", "smallSig0", "smallSig1", "sha256"})
public final class Sha256 {
    @NotNull
    public static final Sha256 INSTANCE = new Sha256();
    @NotNull
    private static final int[] K;
    @NotNull
    private static final int[] H0;
    @NotNull
    private static final int[] W;
    @NotNull
    private static final int[] H;
    @NotNull
    private static final int[] TEMP;

    private Sha256() {
    }

    @NotNull
    public final byte[] digest(@NotNull byte[] message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        IntArrayExtensionsKt.copy(H0, 0, H, 0, H0.length);
        int[] words = ByteArrayExtensionsKt.toIntArray(this.padMessage$sha256(message));
        int n = words.length / 16;
        for (int i = 0; i < n; ++i) {
            int t;
            IntArrayExtensionsKt.copy(words, i * 16, W, 0, 16);
            int n2 = 16;
            int n3 = W.length;
            if (n2 < n3) {
                do {
                    t = n2++;
                    Sha256.W[t] = this.smallSig1(W[t - 2]) + W[t - 7] + this.smallSig0(W[t - 15]) + W[t - 16];
                } while (n2 < n3);
            }
            IntArrayExtensionsKt.copy(H, 0, TEMP, 0, H.length);
            n2 = 0;
            n3 = W.length + -1;
            if (n2 <= n3) {
                do {
                    t = n2++;
                    int t1 = TEMP[7] + this.bigSig1(TEMP[4]) + this.ch(TEMP[4], TEMP[5], TEMP[6]) + K[t] + W[t];
                    int t2 = this.bigSig0(TEMP[0]) + this.maj(TEMP[0], TEMP[1], TEMP[2]);
                    IntArrayExtensionsKt.copy(TEMP, 0, TEMP, 1, TEMP.length - 1);
                    int[] nArray = TEMP;
                    nArray[4] = nArray[4] + t1;
                    Sha256.TEMP[0] = t1 + t2;
                } while (n2 <= n3);
            }
            if ((n2 = 0) > (n3 = H.length + -1)) continue;
            do {
                t = n2++;
                int[] nArray = H;
                int n4 = t;
                nArray[n4] = nArray[n4] + TEMP[t];
            } while (n2 <= n3);
        }
        return IntArrayExtensionsKt.toByteArray(H);
    }

    @NotNull
    public final byte[] padMessage$sha256(@NotNull byte[] message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        int blockBits = 512;
        int blockBytes = blockBits / 8;
        int newMessageLength = message.length + 1 + 8;
        int padBytes = blockBytes - newMessageLength % blockBytes;
        byte[] paddedMessage = new byte[newMessageLength += padBytes];
        ByteArrayExtensionsKt.copy(message, 0, paddedMessage, 0, message.length);
        paddedMessage[message.length] = -128;
        int lenPos = message.length + 1 + padBytes;
        ByteArrayExtensionsKt.putLong(paddedMessage, lenPos, (long)message.length * 8L);
        return paddedMessage;
    }

    private final int ch(int x, int y, int z) {
        return x & y | ~x & z;
    }

    private final int maj(int x, int y, int z) {
        return x & y | x & z | y & z;
    }

    private final int bigSig0(int x) {
        return IntExtensionsKt.rotateRight(x, 2) ^ IntExtensionsKt.rotateRight(x, 13) ^ IntExtensionsKt.rotateRight(x, 22);
    }

    private final int bigSig1(int x) {
        return IntExtensionsKt.rotateRight(x, 6) ^ IntExtensionsKt.rotateRight(x, 11) ^ IntExtensionsKt.rotateRight(x, 25);
    }

    private final int smallSig0(int x) {
        return IntExtensionsKt.rotateRight(x, 7) ^ IntExtensionsKt.rotateRight(x, 18) ^ x >>> 3;
    }

    private final int smallSig1(int x) {
        return IntExtensionsKt.rotateRight(x, 17) ^ IntExtensionsKt.rotateRight(x, 19) ^ x >>> 10;
    }

    static {
        int[] nArray = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
        K = nArray;
        nArray = new int[]{1779033703, -1150833019, 1013904242, -1521486534, 1359893119, -1694144372, 528734635, 1541459225};
        H0 = nArray;
        W = new int[64];
        H = new int[8];
        TEMP = new int[8];
    }
}

