/*
 * Decompiled with CFR 0.152.
 */
package org.komputing.khash.ripemd160;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0012\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u0005\n\u0002\b\u0003\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0006J \u0010\u0014\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J \u0010\u0017\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J \u0010\u0018\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J \u0010\u0019\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J \u0010\u001a\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0006H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001cH\u0002J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u0004H\u0002J\u0018\u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u0006H\u0002J\b\u0010#\u001a\u00020\u001cH\u0002J\u0018\u0010$\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u0006H\u0002J \u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J\u000e\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*J\u001e\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lorg/komputing/khash/ripemd160/Ripemd160Digest;", "", "()V", "byteCount", "", "h0", "", "h1", "h2", "h3", "h4", "x", "", "xBuf", "", "xBufOff", "xOff", "doFinal", "out", "outOffset", "f1", "y", "z", "f2", "f3", "f4", "f5", "finish", "", "processBlock", "processLength", "bitLength", "processWord", "inputWord", "inputOffset", "reset", "rotateLeft", "n", "unpackWord", "word", "update", "input", "", "len", "Companion", "ripemd160"})
public final class Ripemd160Digest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int h0;
    private int h1;
    private int h2;
    private int h3;
    private int h4;
    @NotNull
    private final int[] x = new int[16];
    private int xOff;
    @NotNull
    private final byte[] xBuf = new byte[4];
    private int xBufOff;
    private long byteCount;
    public static final int DIGEST_LENGTH = 20;

    public Ripemd160Digest() {
        this.reset();
    }

    public final void update(byte input) {
        Ripemd160Digest ripemd160Digest = this;
        int n = ripemd160Digest.xBufOff;
        ripemd160Digest.xBufOff = n + 1;
        this.xBuf[n] = input;
        if (this.xBufOff == this.xBuf.length) {
            this.processWord(this.xBuf, 0);
            this.xBufOff = 0;
        }
        ripemd160Digest = this;
        long l = ripemd160Digest.byteCount;
        ripemd160Digest.byteCount = l + 1L;
    }

    public final void update(@NotNull byte[] input, int inputOffset, int len) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        int pos = inputOffset;
        int toProcess = len;
        while (this.xBufOff != 0 && toProcess > 0) {
            this.update(input[pos]);
            int n = pos;
            pos = n + 1;
            n = toProcess;
            toProcess = n + -1;
        }
        while (toProcess > this.xBuf.length) {
            this.processWord(input, pos);
            pos += this.xBuf.length;
            toProcess -= this.xBuf.length;
            Ripemd160Digest ripemd160Digest = this;
            ripemd160Digest.byteCount += (long)this.xBuf.length;
        }
        while (toProcess > 0) {
            this.update(input[pos]);
            int n = pos;
            pos = n + 1;
            n = toProcess;
            toProcess = n + -1;
        }
    }

    private final void finish() {
        long bitLength = this.byteCount << 3;
        this.update((byte)-128);
        while (this.xBufOff != 0) {
            this.update((byte)0);
        }
        this.processLength(bitLength);
        this.processBlock();
    }

    private final void reset() {
        int i;
        this.byteCount = 0L;
        this.xBufOff = 0;
        int n = 0;
        int n2 = this.xBuf.length + -1;
        if (n <= n2) {
            do {
                i = n++;
                this.xBuf[i] = 0;
            } while (n <= n2);
        }
        this.h0 = 1732584193;
        this.h1 = -271733879;
        this.h2 = -1732584194;
        this.h3 = 271733878;
        this.h4 = -1009589776;
        this.xOff = 0;
        n = 0;
        n2 = this.x.length + -1;
        if (n <= n2) {
            do {
                i = n++;
                this.x[i] = 0;
            } while (n <= n2);
        }
    }

    private final void processWord(byte[] inputWord, int inputOffset) {
        Ripemd160Digest ripemd160Digest = this;
        int n = ripemd160Digest.xOff;
        ripemd160Digest.xOff = n + 1;
        this.x[n] = inputWord[inputOffset] & 0xFF | (inputWord[inputOffset + 1] & 0xFF) << 8 | (inputWord[inputOffset + 2] & 0xFF) << 16 | (inputWord[inputOffset + 3] & 0xFF) << 24;
        if (this.xOff == 16) {
            this.processBlock();
        }
    }

    private final void processLength(long bitLength) {
        if (this.xOff > 14) {
            this.processBlock();
        }
        this.x[14] = (int)(bitLength & 0xFFFFFFFFFFFFFFFFL);
        this.x[15] = (int)(bitLength >>> 32);
    }

    private final void unpackWord(int word, byte[] out, int outOffset) {
        out[outOffset] = (byte)word;
        out[outOffset + 1] = (byte)(word >>> 8);
        out[outOffset + 2] = (byte)(word >>> 16);
        out[outOffset + 3] = (byte)(word >>> 24);
    }

    public final int doFinal(@NotNull byte[] out, int outOffset) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this.finish();
        this.unpackWord(this.h0, out, outOffset);
        this.unpackWord(this.h1, out, outOffset + 4);
        this.unpackWord(this.h2, out, outOffset + 8);
        this.unpackWord(this.h3, out, outOffset + 12);
        this.unpackWord(this.h4, out, outOffset + 16);
        this.reset();
        return 20;
    }

    private final int rotateLeft(int x, int n) {
        return x << n | x >>> 32 - n;
    }

    private final int f1(int x, int y, int z) {
        return x ^ y ^ z;
    }

    private final int f2(int x, int y, int z) {
        return x & y | ~x & z;
    }

    private final int f3(int x, int y, int z) {
        return (x | ~y) ^ z;
    }

    private final int f4(int x, int y, int z) {
        return x & z | y & ~z;
    }

    private final int f5(int x, int y, int z) {
        return x ^ (y | ~z);
    }

    private final void processBlock() {
        int ee;
        int dd;
        int cc;
        int bb;
        int aa;
        int a = aa = this.h0;
        int b = bb = this.h1;
        int c = cc = this.h2;
        int d = dd = this.h3;
        int e = ee = this.h4;
        a = this.rotateLeft(a + this.f1(b, c, d) + this.x[0], 11) + e;
        c = this.rotateLeft(c, 10);
        e = this.rotateLeft(e + this.f1(a, b, c) + this.x[1], 14) + d;
        b = this.rotateLeft(b, 10);
        d = this.rotateLeft(d + this.f1(e, a, b) + this.x[2], 15) + c;
        a = this.rotateLeft(a, 10);
        c = this.rotateLeft(c + this.f1(d, e, a) + this.x[3], 12) + b;
        e = this.rotateLeft(e, 10);
        b = this.rotateLeft(b + this.f1(c, d, e) + this.x[4], 5) + a;
        d = this.rotateLeft(d, 10);
        a = this.rotateLeft(a + this.f1(b, c, d) + this.x[5], 8) + e;
        c = this.rotateLeft(c, 10);
        e = this.rotateLeft(e + this.f1(a, b, c) + this.x[6], 7) + d;
        b = this.rotateLeft(b, 10);
        d = this.rotateLeft(d + this.f1(e, a, b) + this.x[7], 9) + c;
        a = this.rotateLeft(a, 10);
        c = this.rotateLeft(c + this.f1(d, e, a) + this.x[8], 11) + b;
        e = this.rotateLeft(e, 10);
        b = this.rotateLeft(b + this.f1(c, d, e) + this.x[9], 13) + a;
        d = this.rotateLeft(d, 10);
        a = this.rotateLeft(a + this.f1(b, c, d) + this.x[10], 14) + e;
        c = this.rotateLeft(c, 10);
        e = this.rotateLeft(e + this.f1(a, b, c) + this.x[11], 15) + d;
        b = this.rotateLeft(b, 10);
        d = this.rotateLeft(d + this.f1(e, a, b) + this.x[12], 6) + c;
        a = this.rotateLeft(a, 10);
        c = this.rotateLeft(c + this.f1(d, e, a) + this.x[13], 7) + b;
        e = this.rotateLeft(e, 10);
        b = this.rotateLeft(b + this.f1(c, d, e) + this.x[14], 9) + a;
        d = this.rotateLeft(d, 10);
        a = this.rotateLeft(a + this.f1(b, c, d) + this.x[15], 8) + e;
        c = this.rotateLeft(c, 10);
        aa = this.rotateLeft(aa + this.f5(bb, cc, dd) + this.x[5] + 1352829926, 8) + ee;
        cc = this.rotateLeft(cc, 10);
        ee = this.rotateLeft(ee + this.f5(aa, bb, cc) + this.x[14] + 1352829926, 9) + dd;
        bb = this.rotateLeft(bb, 10);
        dd = this.rotateLeft(dd + this.f5(ee, aa, bb) + this.x[7] + 1352829926, 9) + cc;
        aa = this.rotateLeft(aa, 10);
        cc = this.rotateLeft(cc + this.f5(dd, ee, aa) + this.x[0] + 1352829926, 11) + bb;
        ee = this.rotateLeft(ee, 10);
        bb = this.rotateLeft(bb + this.f5(cc, dd, ee) + this.x[9] + 1352829926, 13) + aa;
        dd = this.rotateLeft(dd, 10);
        aa = this.rotateLeft(aa + this.f5(bb, cc, dd) + this.x[2] + 1352829926, 15) + ee;
        cc = this.rotateLeft(cc, 10);
        ee = this.rotateLeft(ee + this.f5(aa, bb, cc) + this.x[11] + 1352829926, 15) + dd;
        bb = this.rotateLeft(bb, 10);
        dd = this.rotateLeft(dd + this.f5(ee, aa, bb) + this.x[4] + 1352829926, 5) + cc;
        aa = this.rotateLeft(aa, 10);
        cc = this.rotateLeft(cc + this.f5(dd, ee, aa) + this.x[13] + 1352829926, 7) + bb;
        ee = this.rotateLeft(ee, 10);
        bb = this.rotateLeft(bb + this.f5(cc, dd, ee) + this.x[6] + 1352829926, 7) + aa;
        dd = this.rotateLeft(dd, 10);
        aa = this.rotateLeft(aa + this.f5(bb, cc, dd) + this.x[15] + 1352829926, 8) + ee;
        cc = this.rotateLeft(cc, 10);
        ee = this.rotateLeft(ee + this.f5(aa, bb, cc) + this.x[8] + 1352829926, 11) + dd;
        bb = this.rotateLeft(bb, 10);
        dd = this.rotateLeft(dd + this.f5(ee, aa, bb) + this.x[1] + 1352829926, 14) + cc;
        aa = this.rotateLeft(aa, 10);
        cc = this.rotateLeft(cc + this.f5(dd, ee, aa) + this.x[10] + 1352829926, 14) + bb;
        ee = this.rotateLeft(ee, 10);
        bb = this.rotateLeft(bb + this.f5(cc, dd, ee) + this.x[3] + 1352829926, 12) + aa;
        dd = this.rotateLeft(dd, 10);
        aa = this.rotateLeft(aa + this.f5(bb, cc, dd) + this.x[12] + 1352829926, 6) + ee;
        cc = this.rotateLeft(cc, 10);
        e = this.rotateLeft(e + this.f2(a, b, c) + this.x[7] + 1518500249, 7) + d;
        b = this.rotateLeft(b, 10);
        d = this.rotateLeft(d + this.f2(e, a, b) + this.x[4] + 1518500249, 6) + c;
        a = this.rotateLeft(a, 10);
        c = this.rotateLeft(c + this.f2(d, e, a) + this.x[13] + 1518500249, 8) + b;
        e = this.rotateLeft(e, 10);
        b = this.rotateLeft(b + this.f2(c, d, e) + this.x[1] + 1518500249, 13) + a;
        d = this.rotateLeft(d, 10);
        a = this.rotateLeft(a + this.f2(b, c, d) + this.x[10] + 1518500249, 11) + e;
        c = this.rotateLeft(c, 10);
        e = this.rotateLeft(e + this.f2(a, b, c) + this.x[6] + 1518500249, 9) + d;
        b = this.rotateLeft(b, 10);
        d = this.rotateLeft(d + this.f2(e, a, b) + this.x[15] + 1518500249, 7) + c;
        a = this.rotateLeft(a, 10);
        c = this.rotateLeft(c + this.f2(d, e, a) + this.x[3] + 1518500249, 15) + b;
        e = this.rotateLeft(e, 10);
        b = this.rotateLeft(b + this.f2(c, d, e) + this.x[12] + 1518500249, 7) + a;
        d = this.rotateLeft(d, 10);
        a = this.rotateLeft(a + this.f2(b, c, d) + this.x[0] + 1518500249, 12) + e;
        c = this.rotateLeft(c, 10);
        e = this.rotateLeft(e + this.f2(a, b, c) + this.x[9] + 1518500249, 15) + d;
        b = this.rotateLeft(b, 10);
        d = this.rotateLeft(d + this.f2(e, a, b) + this.x[5] + 1518500249, 9) + c;
        a = this.rotateLeft(a, 10);
        c = this.rotateLeft(c + this.f2(d, e, a) + this.x[2] + 1518500249, 11) + b;
        e = this.rotateLeft(e, 10);
        b = this.rotateLeft(b + this.f2(c, d, e) + this.x[14] + 1518500249, 7) + a;
        d = this.rotateLeft(d, 10);
        a = this.rotateLeft(a + this.f2(b, c, d) + this.x[11] + 1518500249, 13) + e;
        c = this.rotateLeft(c, 10);
        e = this.rotateLeft(e + this.f2(a, b, c) + this.x[8] + 1518500249, 12) + d;
        b = this.rotateLeft(b, 10);
        ee = this.rotateLeft(ee + this.f4(aa, bb, cc) + this.x[6] + 1548603684, 9) + dd;
        bb = this.rotateLeft(bb, 10);
        dd = this.rotateLeft(dd + this.f4(ee, aa, bb) + this.x[11] + 1548603684, 13) + cc;
        aa = this.rotateLeft(aa, 10);
        cc = this.rotateLeft(cc + this.f4(dd, ee, aa) + this.x[3] + 1548603684, 15) + bb;
        ee = this.rotateLeft(ee, 10);
        bb = this.rotateLeft(bb + this.f4(cc, dd, ee) + this.x[7] + 1548603684, 7) + aa;
        dd = this.rotateLeft(dd, 10);
        aa = this.rotateLeft(aa + this.f4(bb, cc, dd) + this.x[0] + 1548603684, 12) + ee;
        cc = this.rotateLeft(cc, 10);
        ee = this.rotateLeft(ee + this.f4(aa, bb, cc) + this.x[13] + 1548603684, 8) + dd;
        bb = this.rotateLeft(bb, 10);
        dd = this.rotateLeft(dd + this.f4(ee, aa, bb) + this.x[5] + 1548603684, 9) + cc;
        aa = this.rotateLeft(aa, 10);
        cc = this.rotateLeft(cc + this.f4(dd, ee, aa) + this.x[10] + 1548603684, 11) + bb;
        ee = this.rotateLeft(ee, 10);
        bb = this.rotateLeft(bb + this.f4(cc, dd, ee) + this.x[14] + 1548603684, 7) + aa;
        dd = this.rotateLeft(dd, 10);
        aa = this.rotateLeft(aa + this.f4(bb, cc, dd) + this.x[15] + 1548603684, 7) + ee;
        cc = this.rotateLeft(cc, 10);
        ee = this.rotateLeft(ee + this.f4(aa, bb, cc) + this.x[8] + 1548603684, 12) + dd;
        bb = this.rotateLeft(bb, 10);
        dd = this.rotateLeft(dd + this.f4(ee, aa, bb) + this.x[12] + 1548603684, 7) + cc;
        aa = this.rotateLeft(aa, 10);
        cc = this.rotateLeft(cc + this.f4(dd, ee, aa) + this.x[4] + 1548603684, 6) + bb;
        ee = this.rotateLeft(ee, 10);
        bb = this.rotateLeft(bb + this.f4(cc, dd, ee) + this.x[9] + 1548603684, 15) + aa;
        dd = this.rotateLeft(dd, 10);
        aa = this.rotateLeft(aa + this.f4(bb, cc, dd) + this.x[1] + 1548603684, 13) + ee;
        cc = this.rotateLeft(cc, 10);
        ee = this.rotateLeft(ee + this.f4(aa, bb, cc) + this.x[2] + 1548603684, 11) + dd;
        bb = this.rotateLeft(bb, 10);
        d = this.rotateLeft(d + this.f3(e, a, b) + this.x[3] + 1859775393, 11) + c;
        a = this.rotateLeft(a, 10);
        c = this.rotateLeft(c + this.f3(d, e, a) + this.x[10] + 1859775393, 13) + b;
        e = this.rotateLeft(e, 10);
        b = this.rotateLeft(b + this.f3(c, d, e) + this.x[14] + 1859775393, 6) + a;
        d = this.rotateLeft(d, 10);
        a = this.rotateLeft(a + this.f3(b, c, d) + this.x[4] + 1859775393, 7) + e;
        c = this.rotateLeft(c, 10);
        e = this.rotateLeft(e + this.f3(a, b, c) + this.x[9] + 1859775393, 14) + d;
        b = this.rotateLeft(b, 10);
        d = this.rotateLeft(d + this.f3(e, a, b) + this.x[15] + 1859775393, 9) + c;
        a = this.rotateLeft(a, 10);
        c = this.rotateLeft(c + this.f3(d, e, a) + this.x[8] + 1859775393, 13) + b;
        e = this.rotateLeft(e, 10);
        b = this.rotateLeft(b + this.f3(c, d, e) + this.x[1] + 1859775393, 15) + a;
        d = this.rotateLeft(d, 10);
        a = this.rotateLeft(a + this.f3(b, c, d) + this.x[2] + 1859775393, 14) + e;
        c = this.rotateLeft(c, 10);
        e = this.rotateLeft(e + this.f3(a, b, c) + this.x[7] + 1859775393, 8) + d;
        b = this.rotateLeft(b, 10);
        d = this.rotateLeft(d + this.f3(e, a, b) + this.x[0] + 1859775393, 13) + c;
        a = this.rotateLeft(a, 10);
        c = this.rotateLeft(c + this.f3(d, e, a) + this.x[6] + 1859775393, 6) + b;
        e = this.rotateLeft(e, 10);
        b = this.rotateLeft(b + this.f3(c, d, e) + this.x[13] + 1859775393, 5) + a;
        d = this.rotateLeft(d, 10);
        a = this.rotateLeft(a + this.f3(b, c, d) + this.x[11] + 1859775393, 12) + e;
        c = this.rotateLeft(c, 10);
        e = this.rotateLeft(e + this.f3(a, b, c) + this.x[5] + 1859775393, 7) + d;
        b = this.rotateLeft(b, 10);
        d = this.rotateLeft(d + this.f3(e, a, b) + this.x[12] + 1859775393, 5) + c;
        a = this.rotateLeft(a, 10);
        dd = this.rotateLeft(dd + this.f3(ee, aa, bb) + this.x[15] + 1836072691, 9) + cc;
        aa = this.rotateLeft(aa, 10);
        cc = this.rotateLeft(cc + this.f3(dd, ee, aa) + this.x[5] + 1836072691, 7) + bb;
        ee = this.rotateLeft(ee, 10);
        bb = this.rotateLeft(bb + this.f3(cc, dd, ee) + this.x[1] + 1836072691, 15) + aa;
        dd = this.rotateLeft(dd, 10);
        aa = this.rotateLeft(aa + this.f3(bb, cc, dd) + this.x[3] + 1836072691, 11) + ee;
        cc = this.rotateLeft(cc, 10);
        ee = this.rotateLeft(ee + this.f3(aa, bb, cc) + this.x[7] + 1836072691, 8) + dd;
        bb = this.rotateLeft(bb, 10);
        dd = this.rotateLeft(dd + this.f3(ee, aa, bb) + this.x[14] + 1836072691, 6) + cc;
        aa = this.rotateLeft(aa, 10);
        cc = this.rotateLeft(cc + this.f3(dd, ee, aa) + this.x[6] + 1836072691, 6) + bb;
        ee = this.rotateLeft(ee, 10);
        bb = this.rotateLeft(bb + this.f3(cc, dd, ee) + this.x[9] + 1836072691, 14) + aa;
        dd = this.rotateLeft(dd, 10);
        aa = this.rotateLeft(aa + this.f3(bb, cc, dd) + this.x[11] + 1836072691, 12) + ee;
        cc = this.rotateLeft(cc, 10);
        ee = this.rotateLeft(ee + this.f3(aa, bb, cc) + this.x[8] + 1836072691, 13) + dd;
        bb = this.rotateLeft(bb, 10);
        dd = this.rotateLeft(dd + this.f3(ee, aa, bb) + this.x[12] + 1836072691, 5) + cc;
        aa = this.rotateLeft(aa, 10);
        cc = this.rotateLeft(cc + this.f3(dd, ee, aa) + this.x[2] + 1836072691, 14) + bb;
        ee = this.rotateLeft(ee, 10);
        bb = this.rotateLeft(bb + this.f3(cc, dd, ee) + this.x[10] + 1836072691, 13) + aa;
        dd = this.rotateLeft(dd, 10);
        aa = this.rotateLeft(aa + this.f3(bb, cc, dd) + this.x[0] + 1836072691, 13) + ee;
        cc = this.rotateLeft(cc, 10);
        ee = this.rotateLeft(ee + this.f3(aa, bb, cc) + this.x[4] + 1836072691, 7) + dd;
        bb = this.rotateLeft(bb, 10);
        dd = this.rotateLeft(dd + this.f3(ee, aa, bb) + this.x[13] + 1836072691, 5) + cc;
        aa = this.rotateLeft(aa, 10);
        c = this.rotateLeft(c + this.f4(d, e, a) + this.x[1] + -1894007588, 11) + b;
        e = this.rotateLeft(e, 10);
        b = this.rotateLeft(b + this.f4(c, d, e) + this.x[9] + -1894007588, 12) + a;
        d = this.rotateLeft(d, 10);
        a = this.rotateLeft(a + this.f4(b, c, d) + this.x[11] + -1894007588, 14) + e;
        c = this.rotateLeft(c, 10);
        e = this.rotateLeft(e + this.f4(a, b, c) + this.x[10] + -1894007588, 15) + d;
        b = this.rotateLeft(b, 10);
        d = this.rotateLeft(d + this.f4(e, a, b) + this.x[0] + -1894007588, 14) + c;
        a = this.rotateLeft(a, 10);
        c = this.rotateLeft(c + this.f4(d, e, a) + this.x[8] + -1894007588, 15) + b;
        e = this.rotateLeft(e, 10);
        b = this.rotateLeft(b + this.f4(c, d, e) + this.x[12] + -1894007588, 9) + a;
        d = this.rotateLeft(d, 10);
        a = this.rotateLeft(a + this.f4(b, c, d) + this.x[4] + -1894007588, 8) + e;
        c = this.rotateLeft(c, 10);
        e = this.rotateLeft(e + this.f4(a, b, c) + this.x[13] + -1894007588, 9) + d;
        b = this.rotateLeft(b, 10);
        d = this.rotateLeft(d + this.f4(e, a, b) + this.x[3] + -1894007588, 14) + c;
        a = this.rotateLeft(a, 10);
        c = this.rotateLeft(c + this.f4(d, e, a) + this.x[7] + -1894007588, 5) + b;
        e = this.rotateLeft(e, 10);
        b = this.rotateLeft(b + this.f4(c, d, e) + this.x[15] + -1894007588, 6) + a;
        d = this.rotateLeft(d, 10);
        a = this.rotateLeft(a + this.f4(b, c, d) + this.x[14] + -1894007588, 8) + e;
        c = this.rotateLeft(c, 10);
        e = this.rotateLeft(e + this.f4(a, b, c) + this.x[5] + -1894007588, 6) + d;
        b = this.rotateLeft(b, 10);
        d = this.rotateLeft(d + this.f4(e, a, b) + this.x[6] + -1894007588, 5) + c;
        a = this.rotateLeft(a, 10);
        c = this.rotateLeft(c + this.f4(d, e, a) + this.x[2] + -1894007588, 12) + b;
        e = this.rotateLeft(e, 10);
        cc = this.rotateLeft(cc + this.f2(dd, ee, aa) + this.x[8] + 2053994217, 15) + bb;
        ee = this.rotateLeft(ee, 10);
        bb = this.rotateLeft(bb + this.f2(cc, dd, ee) + this.x[6] + 2053994217, 5) + aa;
        dd = this.rotateLeft(dd, 10);
        aa = this.rotateLeft(aa + this.f2(bb, cc, dd) + this.x[4] + 2053994217, 8) + ee;
        cc = this.rotateLeft(cc, 10);
        ee = this.rotateLeft(ee + this.f2(aa, bb, cc) + this.x[1] + 2053994217, 11) + dd;
        bb = this.rotateLeft(bb, 10);
        dd = this.rotateLeft(dd + this.f2(ee, aa, bb) + this.x[3] + 2053994217, 14) + cc;
        aa = this.rotateLeft(aa, 10);
        cc = this.rotateLeft(cc + this.f2(dd, ee, aa) + this.x[11] + 2053994217, 14) + bb;
        ee = this.rotateLeft(ee, 10);
        bb = this.rotateLeft(bb + this.f2(cc, dd, ee) + this.x[15] + 2053994217, 6) + aa;
        dd = this.rotateLeft(dd, 10);
        aa = this.rotateLeft(aa + this.f2(bb, cc, dd) + this.x[0] + 2053994217, 14) + ee;
        cc = this.rotateLeft(cc, 10);
        ee = this.rotateLeft(ee + this.f2(aa, bb, cc) + this.x[5] + 2053994217, 6) + dd;
        bb = this.rotateLeft(bb, 10);
        dd = this.rotateLeft(dd + this.f2(ee, aa, bb) + this.x[12] + 2053994217, 9) + cc;
        aa = this.rotateLeft(aa, 10);
        cc = this.rotateLeft(cc + this.f2(dd, ee, aa) + this.x[2] + 2053994217, 12) + bb;
        ee = this.rotateLeft(ee, 10);
        bb = this.rotateLeft(bb + this.f2(cc, dd, ee) + this.x[13] + 2053994217, 9) + aa;
        dd = this.rotateLeft(dd, 10);
        aa = this.rotateLeft(aa + this.f2(bb, cc, dd) + this.x[9] + 2053994217, 12) + ee;
        cc = this.rotateLeft(cc, 10);
        ee = this.rotateLeft(ee + this.f2(aa, bb, cc) + this.x[7] + 2053994217, 5) + dd;
        bb = this.rotateLeft(bb, 10);
        dd = this.rotateLeft(dd + this.f2(ee, aa, bb) + this.x[10] + 2053994217, 15) + cc;
        aa = this.rotateLeft(aa, 10);
        cc = this.rotateLeft(cc + this.f2(dd, ee, aa) + this.x[14] + 2053994217, 8) + bb;
        ee = this.rotateLeft(ee, 10);
        b = this.rotateLeft(b + this.f5(c, d, e) + this.x[4] + -1454113458, 9) + a;
        d = this.rotateLeft(d, 10);
        a = this.rotateLeft(a + this.f5(b, c, d) + this.x[0] + -1454113458, 15) + e;
        c = this.rotateLeft(c, 10);
        e = this.rotateLeft(e + this.f5(a, b, c) + this.x[5] + -1454113458, 5) + d;
        b = this.rotateLeft(b, 10);
        d = this.rotateLeft(d + this.f5(e, a, b) + this.x[9] + -1454113458, 11) + c;
        a = this.rotateLeft(a, 10);
        c = this.rotateLeft(c + this.f5(d, e, a) + this.x[7] + -1454113458, 6) + b;
        e = this.rotateLeft(e, 10);
        b = this.rotateLeft(b + this.f5(c, d, e) + this.x[12] + -1454113458, 8) + a;
        d = this.rotateLeft(d, 10);
        a = this.rotateLeft(a + this.f5(b, c, d) + this.x[2] + -1454113458, 13) + e;
        c = this.rotateLeft(c, 10);
        e = this.rotateLeft(e + this.f5(a, b, c) + this.x[10] + -1454113458, 12) + d;
        b = this.rotateLeft(b, 10);
        d = this.rotateLeft(d + this.f5(e, a, b) + this.x[14] + -1454113458, 5) + c;
        a = this.rotateLeft(a, 10);
        c = this.rotateLeft(c + this.f5(d, e, a) + this.x[1] + -1454113458, 12) + b;
        e = this.rotateLeft(e, 10);
        b = this.rotateLeft(b + this.f5(c, d, e) + this.x[3] + -1454113458, 13) + a;
        d = this.rotateLeft(d, 10);
        a = this.rotateLeft(a + this.f5(b, c, d) + this.x[8] + -1454113458, 14) + e;
        c = this.rotateLeft(c, 10);
        e = this.rotateLeft(e + this.f5(a, b, c) + this.x[11] + -1454113458, 11) + d;
        b = this.rotateLeft(b, 10);
        d = this.rotateLeft(d + this.f5(e, a, b) + this.x[6] + -1454113458, 8) + c;
        a = this.rotateLeft(a, 10);
        c = this.rotateLeft(c + this.f5(d, e, a) + this.x[15] + -1454113458, 5) + b;
        e = this.rotateLeft(e, 10);
        b = this.rotateLeft(b + this.f5(c, d, e) + this.x[13] + -1454113458, 6) + a;
        d = this.rotateLeft(d, 10);
        bb = this.rotateLeft(bb + this.f1(cc, dd, ee) + this.x[12], 8) + aa;
        dd = this.rotateLeft(dd, 10);
        aa = this.rotateLeft(aa + this.f1(bb, cc, dd) + this.x[15], 5) + ee;
        cc = this.rotateLeft(cc, 10);
        ee = this.rotateLeft(ee + this.f1(aa, bb, cc) + this.x[10], 12) + dd;
        bb = this.rotateLeft(bb, 10);
        dd = this.rotateLeft(dd + this.f1(ee, aa, bb) + this.x[4], 9) + cc;
        aa = this.rotateLeft(aa, 10);
        cc = this.rotateLeft(cc + this.f1(dd, ee, aa) + this.x[1], 12) + bb;
        ee = this.rotateLeft(ee, 10);
        bb = this.rotateLeft(bb + this.f1(cc, dd, ee) + this.x[5], 5) + aa;
        dd = this.rotateLeft(dd, 10);
        aa = this.rotateLeft(aa + this.f1(bb, cc, dd) + this.x[8], 14) + ee;
        cc = this.rotateLeft(cc, 10);
        ee = this.rotateLeft(ee + this.f1(aa, bb, cc) + this.x[7], 6) + dd;
        bb = this.rotateLeft(bb, 10);
        dd = this.rotateLeft(dd + this.f1(ee, aa, bb) + this.x[6], 8) + cc;
        aa = this.rotateLeft(aa, 10);
        cc = this.rotateLeft(cc + this.f1(dd, ee, aa) + this.x[2], 13) + bb;
        ee = this.rotateLeft(ee, 10);
        bb = this.rotateLeft(bb + this.f1(cc, dd, ee) + this.x[13], 6) + aa;
        dd = this.rotateLeft(dd, 10);
        aa = this.rotateLeft(aa + this.f1(bb, cc, dd) + this.x[14], 5) + ee;
        cc = this.rotateLeft(cc, 10);
        ee = this.rotateLeft(ee + this.f1(aa, bb, cc) + this.x[0], 15) + dd;
        bb = this.rotateLeft(bb, 10);
        dd = this.rotateLeft(dd + this.f1(ee, aa, bb) + this.x[3], 13) + cc;
        aa = this.rotateLeft(aa, 10);
        cc = this.rotateLeft(cc + this.f1(dd, ee, aa) + this.x[9], 11) + bb;
        ee = this.rotateLeft(ee, 10);
        bb = this.rotateLeft(bb + this.f1(cc, dd, ee) + this.x[11], 11) + aa;
        dd = this.rotateLeft(dd, 10);
        this.h1 = this.h2 + d + ee;
        this.h2 = this.h3 + e + aa;
        this.h3 = this.h4 + a + bb;
        this.h4 = this.h0 + b + cc;
        this.h0 = dd += c + this.h1;
        this.xOff = 0;
        int n = 0;
        int n2 = this.x.length + -1;
        if (n <= n2) {
            do {
                int i = n++;
                this.x[i] = 0;
            } while (n <= n2);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/komputing/khash/ripemd160/Ripemd160Digest$Companion;", "", "()V", "DIGEST_LENGTH", "", "ripemd160"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

