/*
 * Decompiled with CFR 0.152.
 */
package org.kethereum.rlp;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kethereum.rlp.DecodeResult;
import org.kethereum.rlp.IllegalRLPException;
import org.kethereum.rlp.LengthAndOffset;
import org.kethereum.rlp.RLPList;
import org.kethereum.rlp.RLPType;
import org.kethereum.rlp.RLPTypeConverterKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0016\u0010\u0003\u001a\u00020\u0004*\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001c\u0010\u0007\u001a\u00020\b*\u00020\u00022\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\n"}, d2={"decodeRLP", "Lorg/kethereum/rlp/RLPType;", "", "decodeRLPWithSize", "Lorg/kethereum/rlp/DecodeResult;", "offset", "", "getLengthAndOffset", "Lorg/kethereum/rlp/LengthAndOffset;", "firstByte", "rlp"})
public final class RLPDecoderKt {
    @NotNull
    public static final RLPType decodeRLP(@NotNull byte[] $this$decodeRLP) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeRLP, (String)"$this$decodeRLP");
        return RLPDecoderKt.decodeRLPWithSize$default($this$decodeRLP, 0, 1, null).getElement();
    }

    private static final DecodeResult decodeRLPWithSize(byte[] $this$decodeRLPWithSize, int offset) {
        DecodeResult decodeResult;
        if (offset >= $this$decodeRLPWithSize.length) {
            throw (Throwable)new IllegalRLPException("Cannot decode RLP at offset=" + offset + " and size=" + $this$decodeRLPWithSize.length);
        }
        int value = $this$decodeRLPWithSize[offset] & 0xFF;
        if (value < 128) {
            decodeResult = new DecodeResult(RLPTypeConverterKt.toRLP((byte)value), 1);
        } else if (value < 192) {
            int n = value - 128;
            boolean bl = false;
            boolean bl2 = false;
            int it = n;
            boolean bl3 = false;
            LengthAndOffset lengthAndOffset = RLPDecoderKt.getLengthAndOffset($this$decodeRLPWithSize, it, offset);
            byte[] byArray = $this$decodeRLPWithSize;
            int n2 = lengthAndOffset.getOffset();
            int n3 = lengthAndOffset.getOffset() + lengthAndOffset.getLength();
            boolean bl4 = false;
            DecodeResult decodeResult2 = new DecodeResult(RLPTypeConverterKt.toRLP(ArraysKt.copyOfRange((byte[])byArray, (int)n2, (int)n3)), lengthAndOffset.getLength() + lengthAndOffset.getOffset() - offset);
            decodeResult = decodeResult2;
        } else {
            DecodeResult element;
            int n = value - 192;
            boolean bl = false;
            boolean bl5 = false;
            int it = n;
            boolean bl6 = false;
            boolean lengthAndOffset = false;
            List list = new ArrayList();
            LengthAndOffset lengthAndOffset2 = RLPDecoderKt.getLengthAndOffset($this$decodeRLPWithSize, it, offset);
            for (int currentOffset = lengthAndOffset2.getOffset(); currentOffset < lengthAndOffset2.getOffset() + lengthAndOffset2.getLength(); currentOffset += element.getSize()) {
                element = RLPDecoderKt.decodeRLPWithSize($this$decodeRLPWithSize, currentOffset);
                list.add(element.getElement());
            }
            decodeResult = new DecodeResult(new RLPList(list), lengthAndOffset2.getOffset() + lengthAndOffset2.getLength() - offset);
        }
        return decodeResult;
    }

    static /* synthetic */ DecodeResult decodeRLPWithSize$default(byte[] byArray, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return RLPDecoderKt.decodeRLPWithSize(byArray, n);
    }

    private static final LengthAndOffset getLengthAndOffset(byte[] $this$getLengthAndOffset, int firstByte, int offset) {
        LengthAndOffset lengthAndOffset;
        if (firstByte <= 55) {
            lengthAndOffset = new LengthAndOffset(firstByte, offset + 1);
        } else {
            int size = firstByte - 54;
            byte[] byArray = $this$getLengthAndOffset;
            int n = offset + 1;
            int n2 = offset + size;
            boolean bl = false;
            int length = new BigInteger(1, ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2)).intValue();
            lengthAndOffset = new LengthAndOffset(length, offset + size);
        }
        return lengthAndOffset;
    }
}

