/*
 * Decompiled with CFR 0.152.
 */
package org.kethereum.model;

import java.math.BigInteger;
import java.security.SignatureException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kethereum.extensions.BigIntegerKt;
import org.komputing.khex.extensions.HexStringExtensionsKt;
import org.komputing.khex.model.HexString;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\nR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\b\"\u0004\b\u000e\u0010\n\u00a8\u0006\u001b"}, d2={"Lorg/kethereum/model/SignatureData;", "", "r", "Ljava/math/BigInteger;", "s", "v", "(Ljava/math/BigInteger;Ljava/math/BigInteger;Ljava/math/BigInteger;)V", "getR", "()Ljava/math/BigInteger;", "setR", "(Ljava/math/BigInteger;)V", "getS", "setS", "getV", "setV", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "model"})
public final class SignatureData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private BigInteger r;
    @NotNull
    private BigInteger s;
    @NotNull
    private BigInteger v;

    public SignatureData(@NotNull BigInteger r, @NotNull BigInteger s, @NotNull BigInteger v) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this.r = r;
        this.s = s;
        this.v = v;
    }

    public /* synthetic */ SignatureData(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        BigInteger bigInteger4;
        if ((n & 1) != 0) {
            bigInteger4 = BigInteger.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"ZERO");
            bigInteger = bigInteger4;
        }
        if ((n & 2) != 0) {
            bigInteger4 = BigInteger.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"ZERO");
            bigInteger2 = bigInteger4;
        }
        if ((n & 4) != 0) {
            bigInteger4 = BigInteger.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger4, (String)"ZERO");
            bigInteger3 = bigInteger4;
        }
        this(bigInteger, bigInteger2, bigInteger3);
    }

    @NotNull
    public final BigInteger getR() {
        return this.r;
    }

    public final void setR(@NotNull BigInteger bigInteger) {
        Intrinsics.checkNotNullParameter((Object)bigInteger, (String)"<set-?>");
        this.r = bigInteger;
    }

    @NotNull
    public final BigInteger getS() {
        return this.s;
    }

    public final void setS(@NotNull BigInteger bigInteger) {
        Intrinsics.checkNotNullParameter((Object)bigInteger, (String)"<set-?>");
        this.s = bigInteger;
    }

    @NotNull
    public final BigInteger getV() {
        return this.v;
    }

    public final void setV(@NotNull BigInteger bigInteger) {
        Intrinsics.checkNotNullParameter((Object)bigInteger, (String)"<set-?>");
        this.v = bigInteger;
    }

    @NotNull
    public final BigInteger component1() {
        return this.r;
    }

    @NotNull
    public final BigInteger component2() {
        return this.s;
    }

    @NotNull
    public final BigInteger component3() {
        return this.v;
    }

    @NotNull
    public final SignatureData copy(@NotNull BigInteger r, @NotNull BigInteger s, @NotNull BigInteger v) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new SignatureData(r, s, v);
    }

    public static /* synthetic */ SignatureData copy$default(SignatureData signatureData, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n, Object object) {
        if ((n & 1) != 0) {
            bigInteger = signatureData.r;
        }
        if ((n & 2) != 0) {
            bigInteger2 = signatureData.s;
        }
        if ((n & 4) != 0) {
            bigInteger3 = signatureData.v;
        }
        return signatureData.copy(bigInteger, bigInteger2, bigInteger3);
    }

    @NotNull
    public String toString() {
        return "SignatureData(r=" + this.r + ", s=" + this.s + ", v=" + this.v + ')';
    }

    public int hashCode() {
        int result = this.r.hashCode();
        result = result * 31 + this.s.hashCode();
        result = result * 31 + this.v.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SignatureData)) {
            return false;
        }
        SignatureData signatureData = (SignatureData)other;
        if (!Intrinsics.areEqual((Object)this.r, (Object)signatureData.r)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.s, (Object)signatureData.s)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.v, (Object)signatureData.v);
    }

    public SignatureData() {
        this(null, null, null, 7, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/kethereum/model/SignatureData$Companion;", "", "()V", "fromHex", "Lorg/kethereum/model/SignatureData;", "hexSignature", "", "model"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SignatureData fromHex(@NotNull String hexSignature) throws SignatureException {
            Intrinsics.checkNotNullParameter((Object)hexSignature, (String)"hexSignature");
            if (!HexStringExtensionsKt.isValidHex-jorw2Fc((String)HexString.constructor-impl((String)hexSignature))) {
                throw new SignatureException(Intrinsics.stringPlus((String)"Invalid hex string: ", (Object)hexSignature));
            }
            String cleanedHex = HexStringExtensionsKt.clean0xPrefix-jorw2Fc((String)HexString.constructor-impl((String)hexSignature));
            if (cleanedHex.length() <= 128) {
                throw new SignatureException("Signature hex too short, expected more than 128 digits");
            }
            String string = cleanedHex.substring(0, 64);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            BigInteger r = BigIntegerKt.hexToBigInteger-jorw2Fc((String)HexString.constructor-impl((String)string));
            String string2 = cleanedHex.substring(64, 128);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            BigInteger s = BigIntegerKt.hexToBigInteger-jorw2Fc((String)HexString.constructor-impl((String)string2));
            string2 = cleanedHex.substring(128);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            BigInteger v = BigIntegerKt.hexToBigInteger-jorw2Fc((String)HexString.constructor-impl((String)string2));
            return new SignatureData(r, s, v);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

