/*
 * Decompiled with CFR 0.152.
 */
package org.kethereum.extensions.transactions;

import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kethereum.extensions.ByteListKt;
import org.kethereum.extensions.transactions.TransactionRLPEncoderKt;
import org.kethereum.keccakshortcut.KeccakKt;
import org.kethereum.model.Address;
import org.kethereum.model.Transaction;
import org.komputing.khex.extensions.ByteCollectionExtensionsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\t\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\t\u001a\n\u0010\f\u001a\u00020\r*\u00020\t\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\u000b*\u00020\t\u001a\f\u0010\u000f\u001a\u0004\u0018\u00010\r*\u00020\t\u001a\n\u0010\u0010\u001a\u00020\u000b*\u00020\t\u001a\n\u0010\u0011\u001a\u00020\r*\u00020\t\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\t\u001a\n\u0010\u0014\u001a\u00020\u0013*\u00020\t\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0004\u00a8\u0006\u0015"}, d2={"tokenMintSignature", "", "", "getTokenMintSignature", "()Ljava/util/List;", "tokenTransferSignature", "getTokenTransferSignature", "calculateHash", "", "Lorg/kethereum/model/Transaction;", "getTokenMintTo", "Lorg/kethereum/model/Address;", "getTokenMintValue", "Ljava/math/BigInteger;", "getTokenRelevantTo", "getTokenRelevantValue", "getTokenTransferTo", "getTokenTransferValue", "isTokenMint", "", "isTokenTransfer", "extensions_transactions"})
public final class TransactionFunKt {
    @NotNull
    private static final List<Byte> tokenTransferSignature = CollectionsKt.listOf((Object[])new Byte[]{(byte)169, (byte)5, (byte)156, (byte)187});
    @NotNull
    private static final List<Byte> tokenMintSignature = CollectionsKt.listOf((Object[])new Byte[]{(byte)64, (byte)193, (byte)15, (byte)25});

    @NotNull
    public static final byte[] calculateHash(@NotNull Transaction $this$calculateHash) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateHash, (String)"$this$calculateHash");
        return KeccakKt.keccak((byte[])TransactionRLPEncoderKt.encodeRLP$default($this$calculateHash, null, 1, null));
    }

    @NotNull
    public static final List<Byte> getTokenTransferSignature() {
        return tokenTransferSignature;
    }

    public static final boolean isTokenTransfer(@NotNull Transaction $this$isTokenTransfer) {
        Intrinsics.checkNotNullParameter((Object)$this$isTokenTransfer, (String)"$this$isTokenTransfer");
        return ByteListKt.startsWith((List)ArraysKt.toList((byte[])$this$isTokenTransfer.getInput()), tokenTransferSignature);
    }

    @NotNull
    public static final BigInteger getTokenTransferValue(@NotNull Transaction $this$getTokenTransferValue) {
        Intrinsics.checkNotNullParameter((Object)$this$getTokenTransferValue, (String)"$this$getTokenTransferValue");
        return new BigInteger(ByteCollectionExtensionsKt.toNoPrefixHexString((Collection)ArraysKt.toList((byte[])$this$getTokenTransferValue.getInput()).subList($this$getTokenTransferValue.getInput().length - 32, $this$getTokenTransferValue.getInput().length)), 16);
    }

    @NotNull
    public static final Address getTokenTransferTo(@NotNull Transaction $this$getTokenTransferTo) {
        Intrinsics.checkNotNullParameter((Object)$this$getTokenTransferTo, (String)"$this$getTokenTransferTo");
        return new Address(ByteCollectionExtensionsKt.toHexString$default((Collection)ArraysKt.toList((byte[])$this$getTokenTransferTo.getInput()).subList($this$getTokenTransferTo.getInput().length - 32 - 20, $this$getTokenTransferTo.getInput().length - 32), null, (int)1, null));
    }

    @NotNull
    public static final List<Byte> getTokenMintSignature() {
        return tokenMintSignature;
    }

    public static final boolean isTokenMint(@NotNull Transaction $this$isTokenMint) {
        Intrinsics.checkNotNullParameter((Object)$this$isTokenMint, (String)"$this$isTokenMint");
        return ByteListKt.startsWith((List)ArraysKt.toList((byte[])$this$isTokenMint.getInput()), tokenMintSignature);
    }

    @NotNull
    public static final BigInteger getTokenMintValue(@NotNull Transaction $this$getTokenMintValue) {
        Intrinsics.checkNotNullParameter((Object)$this$getTokenMintValue, (String)"$this$getTokenMintValue");
        return TransactionFunKt.getTokenTransferValue($this$getTokenMintValue);
    }

    @NotNull
    public static final Address getTokenMintTo(@NotNull Transaction $this$getTokenMintTo) {
        Intrinsics.checkNotNullParameter((Object)$this$getTokenMintTo, (String)"$this$getTokenMintTo");
        return TransactionFunKt.getTokenTransferTo($this$getTokenMintTo);
    }

    @Nullable
    public static final Address getTokenRelevantTo(@NotNull Transaction $this$getTokenRelevantTo) {
        Intrinsics.checkNotNullParameter((Object)$this$getTokenRelevantTo, (String)"$this$getTokenRelevantTo");
        return TransactionFunKt.isTokenTransfer($this$getTokenRelevantTo) ? TransactionFunKt.getTokenTransferTo($this$getTokenRelevantTo) : (TransactionFunKt.isTokenMint($this$getTokenRelevantTo) ? TransactionFunKt.getTokenMintTo($this$getTokenRelevantTo) : null);
    }

    @Nullable
    public static final BigInteger getTokenRelevantValue(@NotNull Transaction $this$getTokenRelevantValue) {
        Intrinsics.checkNotNullParameter((Object)$this$getTokenRelevantValue, (String)"$this$getTokenRelevantValue");
        return TransactionFunKt.isTokenTransfer($this$getTokenRelevantValue) ? TransactionFunKt.getTokenTransferValue($this$getTokenRelevantValue) : (TransactionFunKt.isTokenMint($this$getTokenRelevantValue) ? TransactionFunKt.getTokenMintValue($this$getTokenRelevantValue) : null);
    }
}

