/*
 * Decompiled with CFR 0.152.
 */
package org.kethereum.erc961;

import java.math.BigInteger;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.kethereum.erc961.InvalidTokenURIException;
import org.kethereum.model.Address;
import org.kethereum.model.ChainId;
import org.kethereum.model.EthereumURI;
import org.kethereum.model.Token;
import org.kethereum.uri.common.CommonEthereumURIData;
import org.kethereum.uri.common.CommonURIParserKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u0001\u001a\n\u0010\b\u001a\u00020\u0004*\u00020\t\u001a\n\u0010\n\u001a\u00020\u0007*\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"FULL_URI_PREFIX", "", "TOKEN_INFO_PREFIX", "isEthereumTokenURI", "", "uri", "parseTokenFromEthereumURI", "Lorg/kethereum/model/Token;", "isTokenURI", "Lorg/kethereum/model/EthereumURI;", "parseToken", "erc961"})
public final class ERC961ParserKt {
    private static final String TOKEN_INFO_PREFIX = "token_info";
    private static final String FULL_URI_PREFIX = "ethereum:token_info";

    public static final boolean isEthereumTokenURI(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return StringsKt.startsWith$default((String)uri, (String)FULL_URI_PREFIX, (boolean)false, (int)2, null);
    }

    @NotNull
    public static final Token parseTokenFromEthereumURI(@NotNull String uri) {
        int n;
        int n2;
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        CommonEthereumURIData commonEthereumURI = CommonURIParserKt.parseCommonURI((EthereumURI)new EthereumURI(uri));
        Map queryMap = MapsKt.toMap((Iterable)commonEthereumURI.getQuery());
        if (StringsKt.startsWith$default((String)uri, (String)"ethereum:2", (boolean)false, (int)2, null) || !commonEthereumURI.getValid()) {
            throw (Throwable)new InvalidTokenURIException();
        }
        String string3 = (String)queryMap.get("symbol");
        if (string3 == null) {
            string3 = "SYM";
        }
        if ((string2 = commonEthereumURI.getAddress()) == null) {
            string2 = "";
        }
        Address address = new Address(string2);
        BigInteger bigInteger = commonEthereumURI.getChainId-az3pVX0();
        if (bigInteger == null) {
            bigInteger = ChainId.constructor-impl((long)1L);
        }
        String string4 = (String)queryMap.get("name");
        String string5 = (String)queryMap.get("decimals");
        if (string5 != null) {
            string = string5;
            n2 = 0;
            n = Integer.parseInt(string);
        } else {
            n = 18;
        }
        string = (String)queryMap.get("type");
        n2 = n;
        String string6 = string4;
        return new Token(string3, address, bigInteger, n2, string, string6, null);
    }

    @NotNull
    public static final Token parseToken(@NotNull EthereumURI $this$parseToken) {
        Intrinsics.checkNotNullParameter((Object)$this$parseToken, (String)"$this$parseToken");
        return ERC961ParserKt.parseTokenFromEthereumURI($this$parseToken.getUri());
    }

    public static final boolean isTokenURI(@NotNull EthereumURI $this$isTokenURI) {
        Intrinsics.checkNotNullParameter((Object)$this$isTokenURI, (String)"$this$isTokenURI");
        return ERC961ParserKt.isEthereumTokenURI($this$isTokenURI.getUri());
    }
}

