/*
 * Decompiled with CFR 0.152.
 */
package org.kethereum.erc67;

import java.math.BigDecimal;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.kethereum.ValuesKt;
import org.kethereum.model.Address;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0002\u001a\u00020\u0003*\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0004*\u00020\u0006\u001a\u0012\u0010\u0005\u001a\u00020\u0004*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u0012\u0010\u0005\u001a\u00020\u0004*\u00020\u00062\u0006\u0010\t\u001a\u00020\n\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"NUMBER_REGEX", "Lkotlin/text/Regex;", "isERC67String", "", "", "toERC67String", "Lorg/kethereum/model/Address;", "valueInEther", "Ljava/math/BigDecimal;", "valueInWei", "Ljava/math/BigInteger;", "erc67"})
public final class ERC67Kt {
    private static final Regex NUMBER_REGEX = new Regex("^[0-9]+$");

    @NotNull
    public static final String toERC67String(@NotNull Address $this$toERC67String) {
        Intrinsics.checkNotNullParameter((Object)$this$toERC67String, (String)"$this$toERC67String");
        return "ethereum:" + $this$toERC67String.getHex();
    }

    @NotNull
    public static final String toERC67String(@NotNull Address $this$toERC67String, @NotNull BigInteger valueInWei) {
        Intrinsics.checkNotNullParameter((Object)$this$toERC67String, (String)"$this$toERC67String");
        Intrinsics.checkNotNullParameter((Object)valueInWei, (String)"valueInWei");
        return "ethereum:" + $this$toERC67String.getHex() + "?value=" + valueInWei;
    }

    @NotNull
    public static final String toERC67String(@NotNull Address $this$toERC67String, @NotNull BigDecimal valueInEther) {
        Intrinsics.checkNotNullParameter((Object)$this$toERC67String, (String)"$this$toERC67String");
        Intrinsics.checkNotNullParameter((Object)valueInEther, (String)"valueInEther");
        BigDecimal bigDecimal = valueInEther;
        BigDecimal bigDecimal2 = new BigDecimal(ValuesKt.getETH_IN_WEI());
        boolean bl = false;
        BigDecimal bigDecimal3 = bigDecimal.multiply(bigDecimal2);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"this.multiply(other)");
        BigInteger bigInteger = bigDecimal3.toBigInteger();
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"(valueInEther * BigDecim\u2026H_IN_WEI)).toBigInteger()");
        return ERC67Kt.toERC67String($this$toERC67String, bigInteger);
    }

    public static final boolean isERC67String(@NotNull String $this$isERC67String) {
        Intrinsics.checkNotNullParameter((Object)$this$isERC67String, (String)"$this$isERC67String");
        return StringsKt.startsWith$default((String)$this$isERC67String, (String)"ethereum:", (boolean)false, (int)2, null);
    }

    public static final /* synthetic */ Regex access$getNUMBER_REGEX$p() {
        return NUMBER_REGEX;
    }
}

