/*
 * Decompiled with CFR 0.152.
 */
package org.kethereum.bip32;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidKeyException;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kethereum.bip32.model.ConstantsKt;
import org.kethereum.bip32.model.ExtendedKey;
import org.kethereum.crypto.ConvertersKt;
import org.kethereum.crypto.CryptoAPI;
import org.kethereum.crypto.KeysKt;
import org.kethereum.crypto.SignKt;
import org.kethereum.crypto.api.mac.Hmac;
import org.kethereum.model.ECKeyPair;
import org.kethereum.model.PrivateKey;
import org.kethereum.model.PublicKey;
import org.komputing.kbase58.Base58Kt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a+\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u0017\u0010\u0000\u001a\u00020\u0001*\u00020\b\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\t\u0010\n\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u000b"}, d2={"toExtendedKey", "Lorg/kethereum/bip32/model/ExtendedKey;", "Lorg/kethereum/bip32/model/Seed;", "publicKeyOnly", "", "testnet", "toExtendedKey-oOkmR4Q", "([BZZ)Lorg/kethereum/bip32/model/ExtendedKey;", "Lorg/kethereum/bip32/model/XPriv;", "toExtendedKey-W_-bHRw", "(Ljava/lang/String;)Lorg/kethereum/bip32/model/ExtendedKey;", "bip32"})
public final class ConverterKt {
    @NotNull
    public static final ExtendedKey toExtendedKey-oOkmR4Q(@NotNull byte[] $this$toExtendedKey, boolean publicKeyOnly, boolean testnet) {
        Intrinsics.checkNotNullParameter((Object)$this$toExtendedKey, (String)"$this$toExtendedKey");
        try {
            ExtendedKey extendedKey;
            byte[] lr;
            byte[] byArray = lr = Hmac.DefaultImpls.init$default((Hmac)CryptoAPI.INSTANCE.getHmac(), (byte[])ConstantsKt.getBITCOIN_SEED(), null, (int)2, null).generate($this$toExtendedKey);
            int n = 0;
            int n2 = 32;
            byte[] l = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
            byte[] byArray2 = lr;
            n2 = 32;
            int n3 = 64;
            byte[] r = ArraysKt.copyOfRange((byte[])byArray2, (int)n2, (int)n3);
            BigInteger m = new BigInteger(1, l);
            if (m.compareTo(SignKt.getCURVE().getN()) >= 0) {
                throw new KeyException("Master key creation resulted in a key with higher modulus. Suggest deriving the next increment.");
            }
            ECKeyPair keyPair = ConvertersKt.toECKeyPair-UWICACY((BigInteger)PrivateKey.constructor-impl((byte[])l));
            if (publicKeyOnly) {
                BigInteger bigInteger = BigInteger.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"ZERO");
                ECKeyPair pubKeyPair = new ECKeyPair(PrivateKey.constructor-impl((BigInteger)bigInteger), keyPair.getPublicKey-ERNsaTg(), null);
                extendedKey = new ExtendedKey(pubKeyPair, r, 0, 0, 0, testnet ? ConstantsKt.getTpub() : ConstantsKt.getXpub());
            } else {
                extendedKey = new ExtendedKey(keyPair, r, 0, 0, 0, testnet ? ConstantsKt.getTprv() : ConstantsKt.getXprv());
            }
            return extendedKey;
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyException(e);
        }
        catch (NoSuchProviderException e) {
            throw new KeyException(e);
        }
        catch (InvalidKeyException e) {
            throw new KeyException(e);
        }
    }

    public static /* synthetic */ ExtendedKey toExtendedKey-oOkmR4Q$default(byte[] byArray, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return ConverterKt.toExtendedKey-oOkmR4Q(byArray, bl, bl2);
    }

    @NotNull
    public static final ExtendedKey toExtendedKey-W_-bHRw(@NotNull String $this$toExtendedKey) {
        ECKeyPair eCKeyPair;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$toExtendedKey, (String)"$this$toExtendedKey");
        byte[] data = Base58Kt.decodeBase58WithChecksum((String)$this$toExtendedKey);
        if (data.length != 78) {
            throw new KeyException("invalid extended key");
        }
        ByteBuffer buff = ByteBuffer.wrap(data).order(ByteOrder.BIG_ENDIAN);
        byte[] versionBytes = new byte[4];
        buff.get(versionBytes);
        if (Arrays.equals(versionBytes, ConstantsKt.getXprv()) || Arrays.equals(versionBytes, ConstantsKt.getTprv())) {
            bl = true;
        } else if (Arrays.equals(versionBytes, ConstantsKt.getXpub()) || Arrays.equals(versionBytes, ConstantsKt.getTpub())) {
            bl = false;
        } else {
            throw new KeyException("invalid version bytes for an extended key");
        }
        boolean hasPrivate = bl;
        byte depth = buff.get();
        int parent = buff.getInt();
        int sequence = buff.getInt();
        byte[] chainCode = new byte[32];
        buff.get(chainCode);
        if (hasPrivate) {
            buff.get();
            byte[] privateBytes = new byte[32];
            buff.get(privateBytes);
            eCKeyPair = ConvertersKt.toECKeyPair-UWICACY((BigInteger)PrivateKey.constructor-impl((byte[])privateBytes));
        } else {
            byte[] compressedPublicBytes = new byte[33];
            buff.get(compressedPublicBytes);
            byte[] uncompressedPublicBytes = KeysKt.decompressKey((byte[])compressedPublicBytes);
            BigInteger bigInteger = BigInteger.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"ZERO");
            ECKeyPair eCKeyPair2 = new ECKeyPair(PrivateKey.constructor-impl((BigInteger)bigInteger), PublicKey.constructor-impl((BigInteger)new BigInteger(1, uncompressedPublicBytes)), null);
            eCKeyPair = eCKeyPair2;
        }
        ECKeyPair keyPair = eCKeyPair;
        return new ExtendedKey(keyPair, chainCode, depth, parent, sequence, versionBytes);
    }
}

