/*
 * Decompiled with CFR 0.152.
 */
package org.kethereum.bip32;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.InvalidKeyException;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.kethereum.bip32.ConverterKt;
import org.kethereum.bip32.model.ExtendedKey;
import org.kethereum.crypto.ConvertersKt;
import org.kethereum.crypto.CryptoAPI;
import org.kethereum.crypto.KeysKt;
import org.kethereum.crypto.SignKt;
import org.kethereum.crypto.api.ec.CurvePoint;
import org.kethereum.crypto.api.mac.Hmac;
import org.kethereum.extensions.BigIntegerKt;
import org.kethereum.model.ECKeyPair;
import org.kethereum.model.PrivateKey;
import org.komputing.kbip44.BIP44;
import org.komputing.kbip44.BIP44Element;
import org.komputing.khash.ripemd160.extensions.PublicExtensionsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\u0012\u0010\u0003\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a&\u0010\u0007\u001a\u00020\u0004*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f\u00f8\u0001\u0000\u00a2\u0006\u0004\b\r\u0010\u000e\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000f"}, d2={"computeFingerPrint", "", "Lorg/kethereum/model/ECKeyPair;", "generateChildKey", "Lorg/kethereum/bip32/model/ExtendedKey;", "element", "Lorg/komputing/kbip44/BIP44Element;", "toKey", "Lorg/kethereum/bip32/model/Seed;", "pathString", "", "testnet", "", "toKey-siqfMno", "([BLjava/lang/String;Z)Lorg/kethereum/bip32/model/ExtendedKey;", "bip32"})
@JvmName(name="BIP32")
public final class BIP32 {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ExtendedKey toKey-siqfMno(@NotNull byte[] $this$toKey, @NotNull String pathString, boolean testnet) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toKey, (String)"$this$toKey");
        Intrinsics.checkNotNullParameter((Object)pathString, (String)"pathString");
        Iterable iterable = new BIP44(pathString).getPath();
        ExtendedKey initial$iv = ConverterKt.toExtendedKey-NOiSe6A$default($this$toKey, false, testnet, 1, null);
        boolean $i$f$fold = false;
        ExtendedKey accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void bip44Element;
            BIP44Element bIP44Element = (BIP44Element)element$iv;
            ExtendedKey current = accumulator$iv;
            boolean bl = false;
            accumulator$iv = BIP32.generateChildKey(current, (BIP44Element)bip44Element);
        }
        return accumulator$iv;
    }

    public static /* synthetic */ ExtendedKey toKey-siqfMno$default(byte[] byArray, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return BIP32.toKey-siqfMno(byArray, string, bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final int computeFingerPrint(ECKeyPair $this$computeFingerPrint) {
        byte[] pubKeyHash = PublicExtensionsKt.digestRipemd160((byte[])org.komputing.khash.sha256.extensions.PublicExtensionsKt.sha256((byte[])KeysKt.getCompressedPublicKey((ECKeyPair)$this$computeFingerPrint)));
        int fingerprint = 0;
        int n = 0;
        int n2 = 3;
        while (n <= n2) {
            void i;
            fingerprint <<= 8;
            fingerprint |= pubKeyHash[i] & 0xFF;
            ++i;
        }
        return fingerprint;
    }

    @NotNull
    public static final ExtendedKey generateChildKey(@NotNull ExtendedKey $this$generateChildKey, @NotNull BIP44Element element) {
        Intrinsics.checkNotNullParameter((Object)$this$generateChildKey, (String)"$this$generateChildKey");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        try {
            ExtendedKey extendedKey;
            byte[] lr;
            boolean bl = !element.getHardened() || !Intrinsics.areEqual((Object)$this$generateChildKey.getKeyPair().getPrivateKey-V6oYYD4(), (Object)BigInteger.ZERO);
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "need private key for private generation using hardened paths";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Hmac mac = Hmac.DefaultImpls.init$default((Hmac)CryptoAPI.INSTANCE.getHmac(), (byte[])$this$generateChildKey.getChainCode$bip32(), null, (int)2, null);
            byte[] extended = null;
            byte[] pub = KeysKt.getCompressedPublicKey((ECKeyPair)$this$generateChildKey.getKeyPair());
            if (element.getHardened()) {
                byte[] privateKeyPaddedBytes = BigIntegerKt.toBytesPadded((BigInteger)$this$generateChildKey.getKeyPair().getPrivateKey-V6oYYD4(), (int)32);
                byte[] byArray = ByteBuffer.allocate(privateKeyPaddedBytes.length + 5).order(ByteOrder.BIG_ENDIAN).put((byte)0).put(privateKeyPaddedBytes).putInt(element.getNumberWithHardeningFlag()).array();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"ByteBuffer\n             \u2026                 .array()");
                extended = byArray;
            } else {
                byte[] byArray = ByteBuffer.allocate(pub.length + 4).order(ByteOrder.BIG_ENDIAN).put(pub).putInt(element.getNumberWithHardeningFlag()).array();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"ByteBuffer\n             \u2026                 .array()");
                extended = byArray;
            }
            byte[] byArray = lr = mac.generate(extended);
            int n = 0;
            int n2 = 32;
            int n3 = 0;
            byte[] l = ArraysKt.copyOfRange((byte[])byArray, (int)n, (int)n2);
            byte[] byArray2 = lr;
            n2 = 32;
            n3 = 64;
            boolean bl5 = false;
            byte[] r = ArraysKt.copyOfRange((byte[])byArray2, (int)n2, (int)n3);
            BigInteger m = new BigInteger(1, l);
            if (m.compareTo(SignKt.getCURVE().getN()) >= 0) {
                throw (Throwable)new KeyException("Child key derivation resulted in a key with higher modulus. Suggest deriving the next increment.");
            }
            if (Intrinsics.areEqual((Object)$this$generateChildKey.getKeyPair().getPrivateKey-V6oYYD4(), (Object)BigInteger.ZERO) ^ true) {
                BigInteger k = m.add($this$generateChildKey.getKeyPair().getPrivateKey-V6oYYD4()).mod(SignKt.getCURVE().getN());
                if (Intrinsics.areEqual((Object)k, (Object)BigInteger.ZERO)) {
                    throw (Throwable)new KeyException("Child key derivation resulted in zeros. Suggest deriving the next increment.");
                }
                BigInteger bigInteger = k;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"k");
                extendedKey = new ExtendedKey(ConvertersKt.toECKeyPair-UWICACY((BigInteger)PrivateKey.constructor-impl((BigInteger)bigInteger)), r, (byte)($this$generateChildKey.getDepth$bip32() + 1), BIP32.computeFingerPrint($this$generateChildKey.getKeyPair()), element.getNumberWithHardeningFlag(), $this$generateChildKey.getVersionBytes$bip32());
            } else {
                CurvePoint q = SignKt.getCURVE().getG().mul(m).add(SignKt.getCURVE().decodePoint(pub)).normalize();
                if (q.isInfinity()) {
                    throw (Throwable)new KeyException("Child key derivation resulted in zeros. Suggest deriving the next increment.");
                }
                CurvePoint point = SignKt.getCURVE().createPoint(q.getX(), q.getY());
                BigInteger bigInteger = BigInteger.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"BigInteger.ZERO");
                extendedKey = new ExtendedKey(new ECKeyPair(PrivateKey.constructor-impl((BigInteger)bigInteger), ConvertersKt.toPublicKey((CurvePoint)point), null), r, (byte)($this$generateChildKey.getDepth$bip32() + 1), BIP32.computeFingerPrint($this$generateChildKey.getKeyPair()), element.getNumberWithHardeningFlag(), $this$generateChildKey.getVersionBytes$bip32());
            }
            return extendedKey;
        }
        catch (NoSuchAlgorithmException e) {
            throw (Throwable)new KeyException(e);
        }
        catch (NoSuchProviderException e) {
            throw (Throwable)new KeyException(e);
        }
        catch (InvalidKeyException e) {
            throw (Throwable)new KeyException(e);
        }
    }
}

