/*
 * Decompiled with CFR 0.152.
 */
package com.kodgemisi.specification;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;

public class GenericSpecificationContainer<E>
implements Specification<E> {
    private final Specification specification;
    private final List<Map<String, String>> parameters;

    GenericSpecificationContainer(Specification specification, List<Map<String, String>> parameters) {
        this.specification = specification;
        this.parameters = Collections.unmodifiableList(parameters);
    }

    GenericSpecificationContainer(Specification specification) {
        this.specification = specification;
        this.parameters = Collections.emptyList();
    }

    public static GenericSpecificationContainer where(Specification specification) {
        return new GenericSpecificationContainer(specification);
    }

    public GenericSpecificationContainer<E> or(GenericSpecificationContainer<E> spec) {
        ArrayList<Map<String, String>> parameterList = new ArrayList<Map<String, String>>(this.parameters);
        parameterList.addAll(spec.parameters);
        return new GenericSpecificationContainer<E>(Specification.where((Specification)this.specification).or(spec), parameterList);
    }

    public Predicate toPredicate(Root<E> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
        return this.specification.toPredicate(root, query, criteriaBuilder);
    }

    public boolean hasParameters() {
        return !this.parameters.isEmpty();
    }

    public List<Map<String, String>> getParameters() {
        return this.parameters;
    }

    public Specification getSpecification() {
        return this.specification;
    }
}

