/*
 * Decompiled with CFR 0.152.
 */
package com.kodgemisi.specification;

import com.kodgemisi.specification.ComparableFilterCriteria;
import com.kodgemisi.specification.CriteriaOperation;
import com.kodgemisi.specification.FilterCriteria;
import com.kodgemisi.specification.RelationType;
import java.util.IllegalFormatException;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;

class GenericSpecification<E, T, C extends Comparable<? super C>>
implements Specification<E> {
    private final FilterCriteria<T> filterCriteria;

    public Predicate toPredicate(Root<E> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
        CriteriaOperation operation = this.filterCriteria.getOperation();
        String key = this.filterCriteria.getKey();
        switch (operation) {
            case JOIN: {
                JoinType joinType = this.filterCriteria.getJoinType();
                root.join(key, joinType);
                return null;
            }
            case JOIN_FETCH: {
                Class clazz = query.getResultType();
                JoinType joinType = this.filterCriteria.getJoinType();
                if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
                    root.join(key, joinType);
                    return null;
                }
                root.fetch(key, joinType);
                query.distinct(true);
                return null;
            }
            case EQUAL: {
                Path<?> path = this.resolvePath(root, this.filterCriteria.getKey(), this.filterCriteria.getRelationType());
                return criteriaBuilder.equal(path, this.filterCriteria.getValue());
            }
            case IS_NULL: {
                Path<?> path = this.resolvePath(root, this.filterCriteria.getKey(), this.filterCriteria.getRelationType());
                return criteriaBuilder.isNull(path);
            }
            case IS_NOT_NULL: {
                Path<?> path = this.resolvePath(root, this.filterCriteria.getKey(), this.filterCriteria.getRelationType());
                return criteriaBuilder.isNotNull(path);
            }
            case LIKE: {
                Path<?> path = this.resolvePath(root, this.filterCriteria.getKey(), this.filterCriteria.getRelationType());
                if (this.filterCriteria.isCaseSensitive()) {
                    criteriaBuilder.like(path.as(String.class), "%" + this.filterCriteria.getValue() + "%");
                } else {
                    return criteriaBuilder.like(criteriaBuilder.lower(path.as(String.class)), "%" + String.valueOf(this.filterCriteria.getValue()).toLowerCase() + "%");
                }
            }
            case IN: {
                Path<?> path = this.resolvePath(root, this.filterCriteria.getKey(), this.filterCriteria.getRelationType());
                return path.in(new Object[]{this.filterCriteria.getValue()});
            }
            case GREATER_THAN: {
                ComparableFilterCriteria<C> comparableFilterCriteria = this.getComparableFilterCriteria();
                Path<?> path = this.resolvePath(root, this.filterCriteria.getKey(), this.filterCriteria.getRelationType());
                return criteriaBuilder.greaterThan(path.as(comparableFilterCriteria.getClazz()), (Comparable)comparableFilterCriteria.getValue());
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                ComparableFilterCriteria<C> comparableFilterCriteria = this.getComparableFilterCriteria();
                Path<?> path = this.resolvePath(root, this.filterCriteria.getKey(), this.filterCriteria.getRelationType());
                return criteriaBuilder.greaterThanOrEqualTo(path.as(comparableFilterCriteria.getClazz()), (Comparable)comparableFilterCriteria.getValue());
            }
            case LESS_THAN: {
                ComparableFilterCriteria<C> comparableFilterCriteria = this.getComparableFilterCriteria();
                Path<?> path = this.resolvePath(root, this.filterCriteria.getKey(), this.filterCriteria.getRelationType());
                return criteriaBuilder.lessThan(path.as(comparableFilterCriteria.getClazz()), (Comparable)comparableFilterCriteria.getValue());
            }
            case LESS_THAN_OR_EQUAL_TO: {
                ComparableFilterCriteria<C> comparableFilterCriteria = this.getComparableFilterCriteria();
                Path<?> path = this.resolvePath(root, this.filterCriteria.getKey(), this.filterCriteria.getRelationType());
                return criteriaBuilder.lessThanOrEqualTo(path.as(comparableFilterCriteria.getClazz()), (Comparable)comparableFilterCriteria.getValue());
            }
        }
        return null;
    }

    private ComparableFilterCriteria<C> getComparableFilterCriteria() {
        if (this.filterCriteria instanceof ComparableFilterCriteria) {
            return (ComparableFilterCriteria)this.filterCriteria;
        }
        throw new ClassCastException("TODO");
    }

    private Path<?> resolvePath(Root<E> root, String key, RelationType relationType) throws IllegalFormatException {
        if (relationType.equals((Object)RelationType.NO_RELATION)) {
            return root.get(key);
        }
        if (relationType.equals((Object)RelationType.TO_ONE)) {
            String[] columns = key.split("\\.");
            if (columns.length == 1) {
                return root.get(key);
            }
            Join joinedTable = root.join(columns[0], JoinType.LEFT);
            Path path = joinedTable.get(columns[1]);
            for (int i = 2; i < columns.length; ++i) {
                path = path.get(columns[i]);
            }
            return path;
        }
        String[] columns = key.split("\\.");
        Join joinedTable = root.join(columns[0], JoinType.LEFT);
        return joinedTable.get(columns[1]);
    }

    public GenericSpecification(FilterCriteria<T> filterCriteria) {
        this.filterCriteria = filterCriteria;
    }
}

