/*
 * Decompiled with CFR 0.152.
 */
package com.github.klieber.phantomjs.util;

import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionUtil.class);

    public static int compare(String versionA, String versionB) {
        if (versionA == versionB) {
            return 0;
        }
        if (versionA == null) {
            return -1;
        }
        if (versionB == null) {
            return 1;
        }
        return new ComparableVersion(versionA).compareTo(new ComparableVersion(versionB));
    }

    public static boolean isGreaterThan(String versionA, String versionB) {
        return VersionUtil.compare(versionA, versionB) > 0;
    }

    public static boolean isLessThan(String versionA, String versionB) {
        return VersionUtil.compare(versionA, versionB) < 0;
    }

    public static boolean isGreaterThanOrEqualTo(String versionA, String versionB) {
        return !VersionUtil.isLessThan(versionA, versionB);
    }

    public static boolean isLessThanOrEqualTo(String versionA, String versionB) {
        return !VersionUtil.isGreaterThan(versionA, versionB);
    }

    public static boolean isEqualTo(String versionA, String versionB) {
        return VersionUtil.compare(versionA, versionB) == 0;
    }

    public static int compare(ArtifactVersion versionA, ArtifactVersion versionB) {
        if (versionA == versionB) {
            return 0;
        }
        if (versionA == null) {
            return -1;
        }
        if (versionB == null) {
            return 1;
        }
        return versionA.compareTo((Object)versionB);
    }

    public static boolean isGreaterThanOrEqualTo(ArtifactVersion versionA, ArtifactVersion versionB) {
        return !VersionUtil.isLessThan(versionA, versionB);
    }

    public static boolean isLessThan(ArtifactVersion versionA, ArtifactVersion versionB) {
        return VersionUtil.compare(versionA, versionB) < 0;
    }

    public static boolean isLessThanOrEqualTo(ArtifactVersion versionA, ArtifactVersion versionB) {
        return !VersionUtil.isGreaterThan(versionA, versionB);
    }

    public static boolean isGreaterThan(ArtifactVersion versionA, ArtifactVersion versionB) {
        return VersionUtil.compare(versionA, versionB) > 0;
    }

    public static boolean isWithin(String version, VersionRange versionRange) {
        DefaultArtifactVersion artifactVersion = new DefaultArtifactVersion(version);
        ArtifactVersion recommendedVersion = versionRange.getRecommendedVersion();
        return recommendedVersion != null ? VersionUtil.isLessThanOrEqualTo(recommendedVersion, (ArtifactVersion)artifactVersion) : versionRange.containsVersion((ArtifactVersion)artifactVersion);
    }

    public static boolean isWithin(String version, String versionSpec) {
        boolean within = false;
        try {
            return VersionUtil.isWithin(version, VersionRange.createFromVersionSpec((String)versionSpec));
        }
        catch (InvalidVersionSpecificationException e) {
            LOGGER.warn("Invalid version specification: {}", (Object)versionSpec);
            return within;
        }
    }
}

