/*
 * Decompiled with CFR 0.152.
 */
package com.github.klieber.phantomjs.resolve;

import com.github.klieber.phantomjs.exec.ExecutionException;
import com.github.klieber.phantomjs.exec.PhantomJsProcessBuilder;
import com.github.klieber.phantomjs.resolve.BinaryResolver;
import com.github.klieber.phantomjs.util.VersionUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.codehaus.plexus.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhantomJsBinaryResolver
implements BinaryResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhantomJsBinaryResolver.class);
    private static final String FOUND_PHANTOMJS = "Found phantomjs {} at {}";
    private static final String SYSTEM_CHECK_FAILURE = "Failed to check system path";
    private static final List<String> BINARY_NAMES = Arrays.asList("phantomjs", "phantomjs.exe");
    private final String versionSpec;

    public PhantomJsBinaryResolver(String versionSpec) {
        this.versionSpec = versionSpec;
    }

    @Override
    public String resolve(String path) {
        String binaryName;
        String binaryPath = null;
        Iterator<String> i$ = BINARY_NAMES.iterator();
        while (i$.hasNext() && (binaryPath = this.getBinaryPath(path, binaryName = i$.next())) == null) {
        }
        return binaryPath;
    }

    private String getBinaryPath(String path, String binary) {
        String versionString;
        File file = new File(path, binary);
        if (file.exists() && (versionString = this.getVersion(file.getAbsolutePath())) != null && VersionUtil.isWithin(versionString, this.versionSpec)) {
            String absolutePath = file.getAbsolutePath();
            LOGGER.info(FOUND_PHANTOMJS, (Object)versionString, (Object)absolutePath);
            return absolutePath;
        }
        return null;
    }

    private String getVersion(String binary) {
        try {
            Process process = new PhantomJsProcessBuilder(binary).commandLineOptions("-v").start();
            BufferedReader standardOut = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String versionString = StringUtils.trim((String)standardOut.readLine());
            return process.waitFor() == 0 ? versionString : null;
        }
        catch (ExecutionException e) {
            LOGGER.warn(SYSTEM_CHECK_FAILURE, (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.warn(SYSTEM_CHECK_FAILURE, (Throwable)e);
        }
        catch (InterruptedException e) {
            LOGGER.warn(SYSTEM_CHECK_FAILURE, (Throwable)e);
        }
        return null;
    }
}

