/*
 * Decompiled with CFR 0.152.
 */
package com.github.klieber.phantomjs.locate;

import com.github.klieber.phantomjs.archive.PhantomJSArchive;
import com.github.klieber.phantomjs.archive.PhantomJSArchiveBuilder;
import com.github.klieber.phantomjs.cache.CachedArtifact;
import com.github.klieber.phantomjs.download.Downloader;
import com.github.klieber.phantomjs.download.RepositoryDownloader;
import com.github.klieber.phantomjs.download.RuleBasedDownloader;
import com.github.klieber.phantomjs.download.WebDownloader;
import com.github.klieber.phantomjs.extract.PhantomJsExtractor;
import com.github.klieber.phantomjs.install.PhantomJsInstaller;
import com.github.klieber.phantomjs.locate.ArchiveLocator;
import com.github.klieber.phantomjs.locate.CompositeLocator;
import com.github.klieber.phantomjs.locate.Locator;
import com.github.klieber.phantomjs.locate.PathLocator;
import com.github.klieber.phantomjs.locate.PhantomJsLocatorOptions;
import com.github.klieber.phantomjs.locate.RepositoryDetails;
import com.github.klieber.phantomjs.resolve.PhantomJsBinaryResolver;
import com.github.klieber.phantomjs.util.ArtifactBuilder;
import com.github.klieber.phantomjs.util.Predicate;
import com.github.klieber.phantomjs.util.Predicates;
import com.github.klieber.phantomjs.util.VersionUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhantomJsLocator
implements Locator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhantomJsLocator.class);
    private final PhantomJsLocatorOptions options;
    private final RepositoryDetails repositoryDetails;
    private static final String LEGACY_VERSION = "1.9.2";
    private static final Predicate<String> IS_LEGACY_VERSION = new Predicate<String>(){

        @Override
        public boolean apply(String version) {
            return VersionUtil.isGreaterThanOrEqualTo(PhantomJsLocator.LEGACY_VERSION, version);
        }
    };
    private static final String GOOGLE_CODE = "https://phantomjs.googlecode.com/files/";
    private static final String BITBUCKET = "https://bitbucket.org/ariya/phantomjs/downloads/";

    public PhantomJsLocator(PhantomJsLocatorOptions options, RepositoryDetails repositoryDetails) {
        this.options = options;
        this.repositoryDetails = repositoryDetails;
    }

    @Override
    public String locate() {
        CompositeLocator locator = new CompositeLocator(this.getLocators());
        return locator.locate();
    }

    private List<Locator> getLocators() {
        ArrayList<Locator> locators = new ArrayList<Locator>();
        if (this.options.isCheckSystemPath()) {
            locators.add(this.getPathLocator(this.getVersionSpec()));
        }
        locators.add(this.getArchiveLocator(this.getPhantomJsArchive(), this.options.getOutputDirectory()));
        return locators;
    }

    private Locator getPathLocator(String versionSpec) {
        String systemPath = System.getenv("PATH");
        List<String> paths = Arrays.asList(systemPath.split(File.pathSeparator));
        return new PathLocator(new PhantomJsBinaryResolver(versionSpec), paths);
    }

    private Locator getArchiveLocator(PhantomJSArchive archive, File outputDirectory) {
        Downloader downloader = this.getDownloader(archive);
        PhantomJsExtractor extractor = new PhantomJsExtractor(archive);
        PhantomJsInstaller installer = new PhantomJsInstaller(downloader, extractor, outputDirectory);
        return new ArchiveLocator(installer, archive);
    }

    private Downloader getDownloader(PhantomJSArchive phantomJSArchive) {
        Downloader downloader;
        ArtifactBuilder artifactBuilder = new ArtifactBuilder();
        CachedArtifact cachedFile = new CachedArtifact(phantomJSArchive, artifactBuilder, this.repositoryDetails.getRepositorySystemSession());
        if (PhantomJsLocatorOptions.Source.REPOSITORY.equals((Object)this.options.getSource())) {
            downloader = new RepositoryDownloader(artifactBuilder, this.repositoryDetails);
        } else if (this.options.getBaseUrl() == null) {
            HashMap<Downloader, Predicate<String>> rules = new HashMap<Downloader, Predicate<String>>();
            rules.put(new WebDownloader(GOOGLE_CODE, cachedFile.getFile()), IS_LEGACY_VERSION);
            rules.put(new WebDownloader(BITBUCKET, cachedFile.getFile()), Predicates.not(IS_LEGACY_VERSION));
            downloader = new RuleBasedDownloader(rules);
        } else {
            downloader = new WebDownloader(this.options.getBaseUrl(), cachedFile.getFile());
        }
        return downloader;
    }

    private PhantomJSArchive getPhantomJsArchive() {
        return new PhantomJSArchiveBuilder(this.options.getVersion()).build();
    }

    private String getVersionSpec() {
        String version = this.options.getVersion();
        String spec = this.options.getEnforceVersion();
        if (spec == null || Boolean.parseBoolean(spec)) {
            spec = "[" + version + "]";
        } else if (Boolean.FALSE.toString().equalsIgnoreCase(spec)) {
            spec = "[0,]";
        } else if (!VersionUtil.isWithin(version, spec)) {
            LOGGER.warn("Version {} is not within requested range: {}", (Object)version, (Object)spec);
        }
        return spec;
    }
}

