/*
 * Decompiled with CFR 0.152.
 */
package com.github.klieber.phantomjs.install;

import com.github.klieber.phantomjs.archive.PhantomJSArchive;
import com.github.klieber.phantomjs.download.DownloadException;
import com.github.klieber.phantomjs.download.Downloader;
import com.github.klieber.phantomjs.extract.ExtractionException;
import com.github.klieber.phantomjs.extract.Extractor;
import com.github.klieber.phantomjs.install.InstallationException;
import com.github.klieber.phantomjs.install.Installer;
import java.io.File;

public class PhantomJsInstaller
implements Installer {
    private static final String UNABLE_TO_INSTALL = "Unable to install phantomjs.";
    private final Downloader downloader;
    private final Extractor extractor;
    private final File outputDirectory;

    public PhantomJsInstaller(Downloader downloader, Extractor extractor, File outputDirectory) {
        this.downloader = downloader;
        this.extractor = extractor;
        this.outputDirectory = outputDirectory;
    }

    @Override
    public String install(PhantomJSArchive phantomJSArchive) throws InstallationException {
        File extractTo = new File(this.outputDirectory, phantomJSArchive.getExtractToPath());
        if (!extractTo.exists()) {
            try {
                File archive = this.downloader.download(phantomJSArchive);
                this.extractor.extract(archive, extractTo);
            }
            catch (DownloadException e) {
                throw new InstallationException(UNABLE_TO_INSTALL, e);
            }
            catch (ExtractionException e) {
                throw new InstallationException(UNABLE_TO_INSTALL, e);
            }
        }
        return extractTo.getAbsolutePath();
    }
}

