/*
 * Decompiled with CFR 0.152.
 */
package com.github.klieber.phantomjs.exec;

import com.github.klieber.phantomjs.exec.ExecutionException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhantomJsProcessBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhantomJsProcessBuilder.class);
    private static final String PHANTOMJS_COMMAND = "phantomjs command: {}";
    private static final String UNABLE_TO_BUILD_CMD_LINE_OPTIONS = "Unable to build command line options.";
    private static final String UNABLE_TO_START = "Unable to start phantomjs process.";
    private final String phantomJsBinary;
    private File configFile;
    private String workingDirectory;
    private String commandLineOptions;
    private String script;
    private List<String> arguments;

    public PhantomJsProcessBuilder(String phantomJsBinary) {
        this.phantomJsBinary = phantomJsBinary;
        this.arguments = new ArrayList<String>();
    }

    public PhantomJsProcessBuilder configFile(File configFile) {
        this.configFile = configFile;
        return this;
    }

    public PhantomJsProcessBuilder workingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
        return this;
    }

    public PhantomJsProcessBuilder commandLineOptions(String commandLineOptions) {
        this.commandLineOptions = commandLineOptions;
        return this;
    }

    public PhantomJsProcessBuilder script(String script) {
        this.script = script;
        return this;
    }

    public PhantomJsProcessBuilder arguments(List<String> arguments) {
        if (arguments != null) {
            this.arguments.addAll(arguments);
        }
        return this;
    }

    public PhantomJsProcessBuilder arguments(String ... arguments) {
        return arguments != null ? this.arguments(Arrays.asList(arguments)) : this;
    }

    public Process start() throws ExecutionException {
        Commandline commandline = this.getCommandLine();
        String[] shellCommandline = commandline.getShellCommandline();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(PHANTOMJS_COMMAND, Arrays.asList(shellCommandline));
        }
        ProcessBuilder processBuilder = new ProcessBuilder(shellCommandline);
        if (commandline.getWorkingDirectory() != null) {
            processBuilder.directory(commandline.getWorkingDirectory());
        }
        try {
            return processBuilder.start();
        }
        catch (IOException e) {
            throw new ExecutionException(UNABLE_TO_START, e);
        }
    }

    private Commandline getCommandLine() throws ExecutionException {
        Commandline commandline = new Commandline(this.phantomJsBinary);
        if (this.configFile != null && this.configFile.exists()) {
            commandline.createArg().setValue("--config=" + this.configFile.getAbsolutePath());
        } else {
            commandline.addArguments(this.getCommandLineOptions(this.commandLineOptions));
        }
        if (this.script != null) {
            commandline.createArg().setValue(this.script);
        }
        if (this.arguments != null) {
            commandline.addArguments(this.arguments.toArray(new String[this.arguments.size()]));
        }
        if (this.workingDirectory != null) {
            commandline.setWorkingDirectory(this.workingDirectory);
        }
        return commandline;
    }

    private String[] getCommandLineOptions(String commandLineOptions) throws ExecutionException {
        try {
            return CommandLineUtils.translateCommandline((String)commandLineOptions);
        }
        catch (Exception e) {
            throw new ExecutionException(UNABLE_TO_BUILD_CMD_LINE_OPTIONS, e);
        }
    }
}

