/*
 * Decompiled with CFR 0.152.
 */
package com.github.klieber.phantomjs.exec;

import com.github.klieber.phantomjs.exec.ExecutionException;
import com.github.klieber.phantomjs.exec.PhantomJsProcessBuilder;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Scanner;

public class PhantomJsExecutor {
    private static final String UNABLE_TO_EXECUTE = "Unable to execute phantomjs process";

    public int execute(PhantomJsProcessBuilder runner) throws ExecutionException {
        try {
            Process process = runner.start();
            PhantomJsExecutor.inheritIO(process.getInputStream(), System.out);
            PhantomJsExecutor.inheritIO(process.getErrorStream(), System.err);
            return process.waitFor();
        }
        catch (InterruptedException e) {
            throw new ExecutionException(UNABLE_TO_EXECUTE, e);
        }
    }

    private static void inheritIO(final InputStream src, final PrintStream dest) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Scanner sc = new Scanner(src);
                while (sc.hasNextLine()) {
                    dest.println(sc.nextLine());
                }
            }
        }).start();
    }
}

