/*
 * Decompiled with CFR 0.152.
 */
package com.github.klieber.phantomjs.download;

import com.github.klieber.phantomjs.archive.PhantomJSArchive;
import com.github.klieber.phantomjs.download.DownloadException;
import com.github.klieber.phantomjs.download.Downloader;
import com.github.klieber.phantomjs.locate.RepositoryDetails;
import com.github.klieber.phantomjs.util.ArtifactBuilder;
import java.io.File;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryDownloader
implements Downloader {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryDownloader.class);
    private static final String UNABLE_TO_RESOLVE = "Unable to resolve artifact.";
    private static final String RESOLVED_ARTIFACT = "Resolved artifact {} from {}";
    private final ArtifactBuilder artifactBuilder;
    private final RepositoryDetails repositoryDetails;

    public RepositoryDownloader(ArtifactBuilder artifactBuilder, RepositoryDetails repositoryDetails) {
        this.artifactBuilder = artifactBuilder;
        this.repositoryDetails = repositoryDetails;
    }

    @Override
    public File download(PhantomJSArchive archive) throws DownloadException {
        ArtifactRequest request = new ArtifactRequest();
        request.setArtifact(this.artifactBuilder.createArtifact(archive));
        request.setRepositories(this.repositoryDetails.getRemoteRepositories());
        try {
            ArtifactResult result = this.repositoryDetails.getRepositorySystem().resolveArtifact(this.repositoryDetails.getRepositorySystemSession(), request);
            LOGGER.info(RESOLVED_ARTIFACT, (Object)result.getArtifact().getFile(), (Object)result.getRepository());
            return result.getArtifact().getFile();
        }
        catch (ArtifactResolutionException e) {
            throw new DownloadException(UNABLE_TO_RESOLVE, e);
        }
    }
}

