/*
 * Decompiled with CFR 0.152.
 */
package org.pcsoft.framework.jremote.ext.config.impl.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXB;
import org.pcsoft.framework.jremote.ext.config.api.ClientConfiguration;
import org.pcsoft.framework.jremote.ext.config.api.exception.JRemoteConfigurationException;
import org.pcsoft.framework.jremote.ext.config.impl.xml.ClientConfigurationType;
import org.pcsoft.framework.jremote.ext.config.impl.xml.RemoteXmlConfiguration;

public final class ClientXmlConfiguration
extends RemoteXmlConfiguration<ClientConfigurationType>
implements ClientConfiguration {
    private int ownPort = 0;

    public static ClientXmlConfiguration loadFrom(File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            ClientXmlConfiguration clientXmlConfiguration = ClientXmlConfiguration.loadFrom(in);
            return clientXmlConfiguration;
        }
    }

    public static ClientXmlConfiguration loadFrom(InputStream in) {
        ClientConfigurationType type = (ClientConfigurationType)JAXB.unmarshal((InputStream)in, ClientConfigurationType.class);
        return ClientXmlConfiguration.loadFrom(type);
    }

    public static ClientXmlConfiguration loadFrom(ClientConfigurationType type) {
        ClientXmlConfiguration configuration = new ClientXmlConfiguration();
        configuration.load(type);
        return configuration;
    }

    private ClientXmlConfiguration() {
    }

    public int getOwnPort() {
        return this.ownPort;
    }

    @Override
    public void validate() throws JRemoteConfigurationException {
        super.validate();
        if (this.ownPort <= 0) {
            throw new JRemoteConfigurationException("Own port not set in configuration");
        }
    }

    @Override
    protected void load(ClientConfigurationType type) throws JRemoteConfigurationException {
        super.load(type);
        this.ownPort = type.getOwnPort();
    }
}

