/*
 * Decompiled with CFR 0.152.
 */
package com.krishna.fileloader.utility;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Environment;
import com.krishna.fileloader.FileLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

public class AndroidFileManager {
    public static File getFileForRequest(Context context, String fileUri, String dirName, int dirType) {
        String fileName = AndroidFileManager.getFileName(fileUri);
        return new File(AndroidFileManager.getAppropriateDirectory(context, dirName, dirType), fileName);
    }

    public static String getFileName(String url) {
        return String.valueOf(url.hashCode());
    }

    public static File getAppropriateDirectory(Context context, String directoryName, int directoryType) {
        File file;
        switch (directoryType) {
            case 2: {
                file = new File(context.getCacheDir(), directoryName);
                break;
            }
            case 3: {
                file = new File(context.getExternalFilesDir(null), directoryName);
                break;
            }
            case 4: {
                file = new File(Environment.getExternalStoragePublicDirectory(null), directoryName);
                break;
            }
            default: {
                file = new File(context.getFilesDir(), directoryName);
            }
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public boolean isExternalStorageWritable() {
        String state = Environment.getExternalStorageState();
        return "mounted".equals(state);
    }

    public boolean isExternalStorageReadable() {
        String state = Environment.getExternalStorageState();
        return "mounted".equals(state) || "mounted_ro".equals(state);
    }

    public static String readFileAsString(File file) {
        StringBuilder sb = new StringBuilder();
        try {
            if (file.exists()) {
                String line;
                InputStreamReader isr = new InputStreamReader(new FileInputStream(file));
                BufferedReader bufferedReader = new BufferedReader(isr);
                while ((line = bufferedReader.readLine()) != null) {
                    sb.append(line);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static Bitmap getBitmap(File downloadedFile) {
        return BitmapFactory.decodeFile((String)downloadedFile.getPath());
    }

    public static void deleteFile(Context context, String fileUri, String dirName, @FileLoader.DirectoryType int dirType) {
        File fileToDelete = AndroidFileManager.getFileForRequest(context, fileUri, dirName, dirType);
        if (fileToDelete.exists()) {
            fileToDelete.delete();
        }
    }
}

