/*
 * Decompiled with CFR 0.152.
 */
package com.krishna.fileloader.builder;

import android.content.Context;
import android.graphics.Bitmap;
import com.krishna.fileloader.FileLoader;
import com.krishna.fileloader.listener.FileRequestListener;
import com.krishna.fileloader.pojo.FileResponse;
import com.krishna.fileloader.request.FileLoadRequest;
import java.io.File;

public class FileLoaderBuilder {
    private Context context;
    private String uri;
    private String directoryName = "file_loader";
    private int directoryType = 1;
    private String fileExtension = "";
    private FileRequestListener listener;
    @FileLoadRequest.ReturnFileType
    private int returnFileType;
    private Class requestClass;
    private FileLoader fileLoader;

    public FileLoaderBuilder(Context context) {
        this.context = context;
    }

    public FileLoaderBuilder load(String uri) {
        this.uri = uri;
        return this;
    }

    public FileLoaderBuilder fromDirectory(String directoryName, @FileLoader.DirectoryType int directoryType) {
        this.directoryName = directoryName;
        this.directoryType = directoryType;
        return this;
    }

    public FileResponse asFile() throws Exception {
        this.returnFileType = 1;
        this.buildFileLoader();
        return this.fileLoader.loadFile();
    }

    public void asFile(FileRequestListener<File> listener) {
        this.returnFileType = 1;
        this.listener = listener;
        this.buildFileLoader();
        this.fileLoader.loadFileAsync();
    }

    public FileResponse asBitmap() throws Exception {
        this.returnFileType = 2;
        this.buildFileLoader();
        return this.fileLoader.loadFile();
    }

    public void asBitmap(FileRequestListener<Bitmap> listener) {
        this.returnFileType = 2;
        this.listener = listener;
        this.buildFileLoader();
        this.fileLoader.loadFileAsync();
    }

    public FileResponse asString() throws Exception {
        this.returnFileType = 4;
        this.buildFileLoader();
        return this.fileLoader.loadFile();
    }

    public void asString(FileRequestListener<String> listener) {
        this.returnFileType = 4;
        this.listener = listener;
        this.buildFileLoader();
        this.fileLoader.loadFileAsync();
    }

    public FileResponse asObject(Class clazz) throws Exception {
        this.returnFileType = 3;
        this.requestClass = clazz;
        this.buildFileLoader();
        return this.fileLoader.loadFile();
    }

    public void asObject(FileRequestListener<? extends Object> listener) {
        this.returnFileType = 3;
        this.listener = listener;
        this.buildFileLoader();
        this.fileLoader.loadFileAsync();
    }

    private void buildFileLoader() {
        this.fileLoader = new FileLoader(this.context);
        this.fileLoader.setFileLoadRequest(new FileLoadRequest(this.uri, this.directoryName, this.directoryType, this.returnFileType, this.requestClass, this.fileExtension, this.listener));
    }
}

