/*
 * Decompiled with CFR 0.152.
 */
package com.krishna.fileloader;

import android.content.Context;
import android.os.AsyncTask;
import com.krishna.fileloader.listener.MultiFileDownloadListener;
import com.krishna.fileloader.network.FileDownloader;
import java.io.File;

public class MultiFileDownloadTask
extends AsyncTask<String, Integer, Void> {
    private MultiFileDownloadListener listener;
    private String dirName;
    private int dirType;
    private Context context;
    private int totalTasks = 0;
    private int progress = 0;
    private File downloadedFile;

    public MultiFileDownloadTask(Context context, String dirName, int dirType, MultiFileDownloadListener listener) {
        this.dirName = dirName;
        this.dirType = dirType;
        this.context = context.getApplicationContext();
        this.listener = listener;
    }

    protected Void doInBackground(String ... urls) {
        this.totalTasks = urls.length;
        for (String url : urls) {
            try {
                FileDownloader downloader = new FileDownloader(this.context, url, this.dirName, this.dirType);
                this.downloadedFile = downloader.download();
                this.publishProgress(new Integer[]{++this.progress});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected void onProgressUpdate(Integer ... values) {
        super.onProgressUpdate((Object[])values);
        if (this.listener != null) {
            try {
                this.listener.onProgress(this.downloadedFile, values[0], this.totalTasks);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

