/*
 * Decompiled with CFR 0.152.
 */
package com.krishna.fileloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.krishna.fileloader.builder.FileDeleteBuilder;
import com.krishna.fileloader.builder.FileLoaderBuilder;
import com.krishna.fileloader.listener.FileRequestListener;
import com.krishna.fileloader.network.FileDownloader;
import com.krishna.fileloader.pojo.DownloadResponse;
import com.krishna.fileloader.pojo.FileResponse;
import com.krishna.fileloader.request.FileDeleteRequest;
import com.krishna.fileloader.request.FileLoadRequest;
import com.krishna.fileloader.utility.AndroidFileManager;
import com.krishna.fileloader.utility.Utils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class FileLoader {
    public static final int DIR_INTERNAL = 1;
    public static final int DIR_CACHE = 2;
    public static final int DIR_EXTERNAL_PRIVATE = 3;
    public static final int DIR_EXTERNAL_PUBLIC = 4;
    public static final int DEFAULT_DIR_TYPE = 1;
    public static final String DEFAULT_DIR_NAME = "file_loader";
    private static Set<FileLoadRequest> fileLoadRequestSet = new HashSet<FileLoadRequest>();
    private static Map<FileLoadRequest, List<FileRequestListener>> requestListenersMap = new ConcurrentHashMap<FileLoadRequest, List<FileRequestListener>>();
    private Context context;
    private FileLoadRequest fileLoadRequest;
    private FileDeleteRequest fileDeleteRequest;

    public FileLoader(Context context) {
        this.context = context.getApplicationContext();
    }

    public static FileLoaderBuilder with(Context context) {
        return new FileLoaderBuilder(context);
    }

    public static FileDeleteBuilder deleteWith(Context context) {
        return new FileDeleteBuilder(context);
    }

    public FileResponse loadFile() throws Exception {
        this.validateAllParameters();
        DownloadResponse response = (DownloadResponse)this.getFileLoaderAsyncTask().execute((Object[])new Void[0]).get();
        if (response.getDownloadedFile() != null) {
            return this.createFileResponse(response.getDownloadedFile());
        }
        throw response.getE();
    }

    public void loadFileAsync() {
        try {
            this.validateAllParameters();
            if (this.fileLoadRequest.getRequestListener() == null) {
                throw new NullPointerException("File Request listener should not be null");
            }
        }
        catch (Exception e) {
            this.callFailureMethodsOfListeners(e);
            return;
        }
        if (fileLoadRequestSet.contains(this.fileLoadRequest)) {
            requestListenersMap.get(this.fileLoadRequest).add(this.fileLoadRequest.getRequestListener());
        } else {
            this.addRequestToQueue();
            this.getFileLoaderAsyncTask().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, (Object[])new Void[0]);
        }
    }

    public int deleteFiles() {
        int fileCount = 0;
        for (String fileUri : this.fileDeleteRequest.getFileUriList()) {
            File file = AndroidFileManager.getFileForRequest(this.context, fileUri, this.fileDeleteRequest.getDirectoryName(), this.fileDeleteRequest.getDirectoryType());
            if (!file.exists()) continue;
            file.delete();
            ++fileCount;
        }
        return fileCount;
    }

    public int deleteAllFiles() {
        File[] allFiles;
        int fileCount = 0;
        File dir = AndroidFileManager.getAppropriateDirectory(this.context, this.fileDeleteRequest.getDirectoryName(), this.fileDeleteRequest.getDirectoryType());
        for (File file : allFiles = dir.listFiles()) {
            file.delete();
            ++fileCount;
        }
        dir.delete();
        return fileCount;
    }

    public int deleteAllFilesExcept() {
        String[] allFiles;
        int fileCount = 0;
        File dir = AndroidFileManager.getAppropriateDirectory(this.context, this.fileDeleteRequest.getDirectoryName(), this.fileDeleteRequest.getDirectoryType());
        HashSet<String> filesToKeepSet = new HashSet<String>();
        for (String fileUri : this.fileDeleteRequest.getFileUriList()) {
            try {
                filesToKeepSet.add(this.getFileName(fileUri));
            }
            catch (Exception exception) {}
        }
        for (String fileName : allFiles = dir.list()) {
            if (filesToKeepSet.contains(fileName)) continue;
            File file = new File(dir, fileName);
            file.delete();
            ++fileCount;
        }
        return fileCount;
    }

    private void validateAllParameters() throws Exception {
        if (TextUtils.isEmpty((CharSequence)this.fileLoadRequest.getDirectoryName())) {
            throw new NullPointerException("Directory name should not be null or empty");
        }
        if (TextUtils.isEmpty((CharSequence)this.fileLoadRequest.getUri())) {
            throw new NullPointerException("File uri should not be null or empty");
        }
        if (this.fileLoadRequest.getFileExtension() == null) {
            throw new NullPointerException("File extension should not be null");
        }
    }

    private void addRequestToQueue() {
        fileLoadRequestSet.add(this.fileLoadRequest);
        List<FileRequestListener> listeners = Collections.synchronizedList(new ArrayList());
        listeners.add(this.fileLoadRequest.getRequestListener());
        requestListenersMap.put(this.fileLoadRequest, listeners);
    }

    private void callFailureMethodsOfListeners(Throwable t) {
        if (!requestListenersMap.isEmpty()) {
            for (FileRequestListener listener : requestListenersMap.get(this.fileLoadRequest)) {
                listener.onError(this.fileLoadRequest, t);
            }
            requestListenersMap.remove(this.fileLoadRequest);
            fileLoadRequestSet.remove(this.fileLoadRequest);
        }
    }

    private FileResponse createFileResponse(File downloadedFile) {
        FileResponse<Object> response = this.fileLoadRequest.getFileType() == 2 ? new FileResponse<Bitmap>(200, AndroidFileManager.getBitmap(downloadedFile), downloadedFile.length()) : (this.fileLoadRequest.getFileType() == 4 ? new FileResponse<String>(200, AndroidFileManager.readFileAsString(downloadedFile), downloadedFile.length()) : (this.fileLoadRequest.getFileType() == 3 ? new FileResponse<Object>(200, Utils.getObject(downloadedFile, this.fileLoadRequest.getRequestClass()), downloadedFile.length()) : new FileResponse<File>(200, downloadedFile, downloadedFile.length())));
        response.setDownloadedFile(downloadedFile);
        return response;
    }

    private void sendFileResponseToListeners(File loadedFile) {
        if (!requestListenersMap.isEmpty()) {
            FileResponse fileResponse = this.createFileResponse(loadedFile);
            for (FileRequestListener listener : requestListenersMap.get(this.fileLoadRequest)) {
                listener.onLoad(this.fileLoadRequest, fileResponse);
            }
            requestListenersMap.remove(this.fileLoadRequest);
            fileLoadRequestSet.remove(this.fileLoadRequest);
        }
    }

    private File searchAndGetLocalFile() throws Exception {
        File[] allFiles;
        File dir;
        this.validateAllParameters();
        File foundFile = null;
        if (!TextUtils.isEmpty((CharSequence)this.fileLoadRequest.getDirectoryName()) && (dir = AndroidFileManager.getAppropriateDirectory(this.context, this.fileLoadRequest.getDirectoryName(), this.fileLoadRequest.getDirectoryType())) != null && dir.exists() && (allFiles = dir.listFiles()) != null) {
            for (File file : allFiles) {
                if (file.isDirectory() || !file.getName().equals(this.getFileName(this.fileLoadRequest.getUri()))) continue;
                foundFile = file;
                break;
            }
        }
        return foundFile;
    }

    private String getFileName(String uri) throws Exception {
        String fileName;
        try {
            new URL(uri);
            fileName = String.valueOf(uri.hashCode());
        }
        catch (MalformedURLException e) {
            if (uri.contains("/")) {
                throw new Exception("File name should not contain path separator \"/\"");
            }
            fileName = uri;
        }
        return fileName;
    }

    @NonNull
    private AsyncTask<Void, Void, DownloadResponse> getFileLoaderAsyncTask() {
        return new AsyncTask<Void, Void, DownloadResponse>(){

            protected DownloadResponse doInBackground(Void ... voids) {
                DownloadResponse downloadResponse = new DownloadResponse();
                try {
                    File loadedFile = FileLoader.this.searchAndGetLocalFile();
                    if (loadedFile == null || !loadedFile.exists()) {
                        FileDownloader downloader = new FileDownloader(FileLoader.this.context, FileLoader.this.fileLoadRequest);
                        loadedFile = downloader.download();
                    }
                    downloadResponse.setDownloadedFile(loadedFile);
                }
                catch (Exception e) {
                    downloadResponse.setE(e);
                }
                return downloadResponse;
            }

            protected void onPostExecute(DownloadResponse downloadResponse) {
                super.onPostExecute((Object)downloadResponse);
                if (FileLoader.this.fileLoadRequest.getRequestListener() == null) {
                    return;
                }
                File downloadedFile = downloadResponse.getDownloadedFile();
                if (downloadedFile != null) {
                    FileLoader.this.sendFileResponseToListeners(downloadedFile);
                } else {
                    FileLoader.this.callFailureMethodsOfListeners(downloadResponse.getE());
                }
            }
        };
    }

    public FileLoadRequest getFileLoadRequest() {
        return this.fileLoadRequest;
    }

    public void setFileLoadRequest(FileLoadRequest fileLoadRequest) {
        this.fileLoadRequest = fileLoadRequest;
    }

    public FileDeleteRequest getFileDeleteRequest() {
        return this.fileDeleteRequest;
    }

    public void setFileDeleteRequest(FileDeleteRequest fileDeleteRequest) {
        this.fileDeleteRequest = fileDeleteRequest;
    }

    public static @interface DirectoryType {
    }
}

