/*
 * Decompiled with CFR 0.152.
 */
package com.krishna.fileloader.utility;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.krishna.fileloader.FileLoader;
import com.krishna.fileloader.utility.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;

public class AndroidFileManager {
    public static File getFileForRequest(Context context, String fileUri, String fileNamePrefix, String dirName, int dirType) throws Exception {
        String fileName = AndroidFileManager.getFileName(fileUri, fileNamePrefix);
        return new File(AndroidFileManager.getAppropriateDirectory(context, dirName, dirType), fileName);
    }

    public static String getFileName(String uri, String fileNamePrefix) throws Exception {
        String fileName;
        try {
            URL url = new URL(uri);
            fileName = AndroidFileManager.getFileNameFromUrl(url);
            if (fileName == null) {
                fileName = String.valueOf(uri.hashCode());
            }
        }
        catch (MalformedURLException e) {
            if (uri.contains("/")) {
                throw new Exception("File name should not contain path separator \"/\"");
            }
            fileName = uri;
        }
        return fileNamePrefix + fileName;
    }

    private static String getFileNameFromUrl(URL url) {
        String lastPath;
        String[] pathArr;
        String fileName = null;
        String path = url.getPath();
        if (path != null && (pathArr = path.split("/")).length > 0 && Utils.isValidFileName(lastPath = pathArr[pathArr.length - 1])) {
            fileName = lastPath;
        }
        return fileName;
    }

    public static File getAppropriateDirectory(Context context, String directoryName, int directoryType) throws Exception {
        File file = null;
        switch (directoryType) {
            case 2: {
                file = new File(context.getCacheDir(), directoryName);
                break;
            }
            case 3: {
                file = AndroidFileManager.getExternalPrivateDirectory(context, directoryName);
                break;
            }
            case 4: {
                file = AndroidFileManager.getExternalPublicDirectory(directoryName);
                break;
            }
            default: {
                file = new File(context.getFilesDir(), directoryName);
            }
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    @NonNull
    private static File getExternalPublicDirectory(String directoryName) throws Exception {
        File file;
        if (AndroidFileManager.isExternalStorageWritable()) {
            File rootDir = Environment.getExternalStorageDirectory();
            file = rootDir == null ? new File(Environment.getExternalStorageDirectory().getAbsolutePath(), directoryName) : new File(rootDir, directoryName);
        } else {
            throw new Exception("External storage is not available for write operation");
        }
        return file;
    }

    private static File getExternalPrivateDirectory(Context context, String directoryName) throws Exception {
        String baseDir = null;
        if (AndroidFileManager.isExternalStorageWritable()) {
            File baseDirFile = context.getExternalFilesDir(null);
            baseDir = baseDirFile == null ? context.getFilesDir().getAbsolutePath() : baseDirFile.getAbsolutePath();
        } else {
            throw new Exception("External storage is not available for write operation");
        }
        return new File(baseDir, directoryName);
    }

    private static boolean isExternalStorageWritable() {
        String state = Environment.getExternalStorageState();
        return "mounted".equals(state);
    }

    public boolean isExternalStorageReadable() {
        String state = Environment.getExternalStorageState();
        return "mounted".equals(state) || "mounted_ro".equals(state);
    }

    public static String readFileAsString(File file) {
        StringBuilder sb = new StringBuilder();
        try {
            if (file.exists()) {
                String line;
                InputStreamReader isr = new InputStreamReader(new FileInputStream(file));
                BufferedReader bufferedReader = new BufferedReader(isr);
                while ((line = bufferedReader.readLine()) != null) {
                    sb.append(line);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static Bitmap getBitmap(File downloadedFile) {
        return BitmapFactory.decodeFile((String)downloadedFile.getPath());
    }

    public static void deleteFile(Context context, String fileUri, String fileNamePrefix, String dirName, @FileLoader.DirectoryType int dirType) throws Exception {
        File fileToDelete = AndroidFileManager.getFileForRequest(context, fileUri, fileNamePrefix, dirName, dirType);
        if (fileToDelete.exists()) {
            fileToDelete.delete();
        }
    }

    public static File searchAndGetLocalFile(Context context, String uri, String fileNamePrefix, String dirName, @FileLoader.DirectoryType int dirType) throws Exception {
        File[] allFiles;
        File dir;
        File foundFile = null;
        if (!TextUtils.isEmpty((CharSequence)dirName) && (dir = AndroidFileManager.getAppropriateDirectory(context, dirName, dirType)) != null && dir.exists() && (allFiles = dir.listFiles()) != null) {
            for (File file : allFiles) {
                if (file.isDirectory() || !file.getName().equals(AndroidFileManager.getFileName(uri, fileNamePrefix))) continue;
                foundFile = file;
                break;
            }
        }
        return foundFile;
    }
}

