/*
 * Decompiled with CFR 0.152.
 */
package com.krishna.fileloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.AsyncTask;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.krishna.fileloader.builder.FileDeleteBuilder;
import com.krishna.fileloader.builder.FileLoaderBuilder;
import com.krishna.fileloader.builder.MultiFileDownloader;
import com.krishna.fileloader.listener.FileRequestListener;
import com.krishna.fileloader.network.FileDownloader;
import com.krishna.fileloader.pojo.DownloadResponse;
import com.krishna.fileloader.pojo.FileResponse;
import com.krishna.fileloader.request.FileDeleteRequest;
import com.krishna.fileloader.request.FileLoadRequest;
import com.krishna.fileloader.utility.AndroidFileManager;
import com.krishna.fileloader.utility.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;

public class FileLoader {
    private static final String TAG = "FileLoader";
    public static final int STATUS_START_LOCAL_SEARCH = 100;
    public static final int STATUS_START_DOWNLOADING = 101;
    public static final int STATUS_DOWNLOAD_END = 102;
    public static final int DIR_INTERNAL = 1;
    public static final int DIR_CACHE = 2;
    public static final int DIR_EXTERNAL_PRIVATE = 3;
    public static final int DIR_EXTERNAL_PUBLIC = 4;
    public static final int DEFAULT_DIR_TYPE = 2;
    public static final String DEFAULT_DIR_NAME = "file_loader";
    private static Map<FileLoadRequest, Boolean> backingMap = new WeakHashMap<FileLoadRequest, Boolean>();
    private static Set<FileLoadRequest> fileLoadRequestSet = Collections.newSetFromMap(backingMap);
    private static Map<FileLoadRequest, List<FileRequestListener>> requestListenersMap = new WeakHashMap<FileLoadRequest, List<FileRequestListener>>();
    private static Map<FileLoadRequest, FileResponse> requestResponseMap = new WeakHashMap<FileLoadRequest, FileResponse>();
    private static final Object REQUEST_QUEUE_LOCK = new Object();
    private static final Object REQUEST_LISTENER_QUEUE_LOCK = new Object();
    private Context context;
    private FileLoadRequest fileLoadRequest;
    private FileDeleteRequest fileDeleteRequest;

    public FileLoader(Context context) {
        this.context = context.getApplicationContext();
    }

    public static FileLoaderBuilder with(Context context) {
        return new FileLoaderBuilder(context);
    }

    public static FileLoaderBuilder with(Context context, boolean autoRefresh) {
        return new FileLoaderBuilder(context, autoRefresh);
    }

    public static FileDeleteBuilder deleteWith(Context context) {
        return new FileDeleteBuilder(context);
    }

    public static MultiFileDownloader multiFileDownload(Context context) {
        return new MultiFileDownloader(context);
    }

    public static MultiFileDownloader multiFileDownload(Context context, boolean autoRefresh) {
        return new MultiFileDownloader(context, autoRefresh);
    }

    public FileResponse loadFile() throws Exception {
        this.validateAllParameters();
        DownloadResponse response = (DownloadResponse)this.getFileLoaderAsyncTask().executeOnExecutor((Executor)Utils.getThreadPoolExecutor(), (Object[])new Void[0]).get();
        if (response.getDownloadedFile() != null) {
            return this.createFileResponse(response.getDownloadedFile());
        }
        throw response.getE();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFileAsync() {
        this.addRequestListenerToQueue();
        try {
            this.validateAllParameters();
            if (this.fileLoadRequest.getRequestListener() == null) {
                throw new NullPointerException("File Request listener should not be null");
            }
        }
        catch (Exception e) {
            this.callFailureMethodsOfListeners(e);
            return;
        }
        if (!fileLoadRequestSet.contains(this.fileLoadRequest)) {
            Object object = REQUEST_QUEUE_LOCK;
            synchronized (object) {
                fileLoadRequestSet.add(this.fileLoadRequest);
            }
            this.getFileLoaderAsyncTask().executeOnExecutor((Executor)Utils.getThreadPoolExecutor(), (Object[])new Void[0]);
        } else if (requestResponseMap.get(this.fileLoadRequest) != null) {
            this.sendFileResponseToListeners(requestResponseMap.get(this.fileLoadRequest));
        }
    }

    public int deleteFiles() throws Exception {
        int fileCount = 0;
        for (String fileUri : this.fileDeleteRequest.getFileUriList()) {
            File file = AndroidFileManager.getFileForRequest(this.context, fileUri, this.fileDeleteRequest.getDirectoryName(), this.fileDeleteRequest.getDirectoryType());
            if (!file.exists()) continue;
            file.delete();
            ++fileCount;
        }
        return fileCount;
    }

    public int deleteAllFiles() throws Exception {
        File[] allFiles;
        int fileCount = 0;
        File dir = AndroidFileManager.getAppropriateDirectory(this.context, this.fileDeleteRequest.getDirectoryName(), this.fileDeleteRequest.getDirectoryType());
        for (File file : allFiles = dir.listFiles()) {
            file.delete();
            ++fileCount;
        }
        dir.delete();
        return fileCount;
    }

    public int deleteAllFilesExcept() throws Exception {
        String[] allFiles;
        int fileCount = 0;
        File dir = AndroidFileManager.getAppropriateDirectory(this.context, this.fileDeleteRequest.getDirectoryName(), this.fileDeleteRequest.getDirectoryType());
        HashSet<String> filesToKeepSet = new HashSet<String>();
        for (String fileUri : this.fileDeleteRequest.getFileUriList()) {
            try {
                filesToKeepSet.add(AndroidFileManager.getFileName(fileUri));
            }
            catch (Exception exception) {}
        }
        for (String fileName : allFiles = dir.list()) {
            if (filesToKeepSet.contains(fileName)) continue;
            File file = new File(dir, fileName);
            file.delete();
            ++fileCount;
        }
        return fileCount;
    }

    private void validateAllParameters() throws Exception {
        if (TextUtils.isEmpty((CharSequence)this.fileLoadRequest.getDirectoryName())) {
            throw new NullPointerException("Directory name should not be null or empty");
        }
        if (TextUtils.isEmpty((CharSequence)this.fileLoadRequest.getUri())) {
            throw new NullPointerException("File uri should not be null or empty");
        }
        if (this.fileLoadRequest.getFileExtension() == null) {
            throw new NullPointerException("File extension should not be null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRequestListenerToQueue() {
        if (requestListenersMap.containsKey(this.fileLoadRequest)) {
            Object object = REQUEST_LISTENER_QUEUE_LOCK;
            synchronized (object) {
                requestListenersMap.get(this.fileLoadRequest).add(this.fileLoadRequest.getRequestListener());
            }
        } else {
            ArrayList<FileRequestListener> listenersList = new ArrayList<FileRequestListener>();
            listenersList.add(this.fileLoadRequest.getRequestListener());
            requestListenersMap.put(this.fileLoadRequest, listenersList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callFailureMethodsOfListeners(Throwable t) {
        if (!requestListenersMap.isEmpty()) {
            Object object = REQUEST_LISTENER_QUEUE_LOCK;
            synchronized (object) {
                List<FileRequestListener> listenerList = requestListenersMap.get(this.fileLoadRequest);
                if (listenerList != null) {
                    Iterator<FileRequestListener> it = listenerList.iterator();
                    while (it.hasNext()) {
                        try {
                            FileRequestListener listener = it.next();
                            it.remove();
                            listener.onError(this.fileLoadRequest, t);
                        }
                        catch (Exception exception) {}
                    }
                    requestListenersMap.remove(this.fileLoadRequest);
                }
            }
            object = REQUEST_QUEUE_LOCK;
            synchronized (object) {
                fileLoadRequestSet.remove(this.fileLoadRequest);
            }
        }
    }

    private FileResponse createFileResponse(File downloadedFile) {
        FileResponse<Object> response = this.fileLoadRequest.getFileType() == 2 ? new FileResponse<Bitmap>(200, AndroidFileManager.getBitmap(downloadedFile), downloadedFile.length()) : (this.fileLoadRequest.getFileType() == 4 ? new FileResponse<String>(200, AndroidFileManager.readFileAsString(downloadedFile), downloadedFile.length()) : (this.fileLoadRequest.getFileType() == 3 ? new FileResponse<Object>(200, Utils.getObject(downloadedFile, this.fileLoadRequest.getRequestClass()), downloadedFile.length()) : new FileResponse<File>(200, downloadedFile, downloadedFile.length())));
        response.setDownloadedFile(downloadedFile);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFileResponseToListeners(FileResponse fileResponse) {
        if (!requestListenersMap.isEmpty()) {
            Object object = REQUEST_LISTENER_QUEUE_LOCK;
            synchronized (object) {
                List<FileRequestListener> listenerList = requestListenersMap.get(this.fileLoadRequest);
                if (listenerList != null) {
                    Iterator<FileRequestListener> it = listenerList.iterator();
                    while (it.hasNext()) {
                        try {
                            FileRequestListener listener = it.next();
                            it.remove();
                            listener.onLoad(this.fileLoadRequest, fileResponse);
                        }
                        catch (Exception e) {
                            this.callFailureMethodsOfListeners(e);
                        }
                    }
                    requestListenersMap.remove(this.fileLoadRequest);
                }
            }
            object = REQUEST_QUEUE_LOCK;
            synchronized (object) {
                fileLoadRequestSet.remove(this.fileLoadRequest);
                requestResponseMap.remove(this.fileLoadRequest);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStatusToListeners(int status) {
        if (!requestListenersMap.isEmpty()) {
            Object object = REQUEST_LISTENER_QUEUE_LOCK;
            synchronized (object) {
                List<FileRequestListener> listenerList = requestListenersMap.get(this.fileLoadRequest);
                if (listenerList != null) {
                    for (FileRequestListener listener : listenerList) {
                        listener.onStatusChange(status);
                    }
                }
            }
        }
    }

    @NonNull
    private AsyncTask<Void, Integer, DownloadResponse> getFileLoaderAsyncTask() {
        return new AsyncTask<Void, Integer, DownloadResponse>(){

            protected void onProgressUpdate(Integer ... values) {
                super.onProgressUpdate((Object[])values);
                if (values.length > 0) {
                    FileLoader.this.sendStatusToListeners(values[0]);
                }
            }

            protected DownloadResponse doInBackground(Void ... voids) {
                DownloadResponse downloadResponse = new DownloadResponse();
                File loadedFile = null;
                try {
                    if (!FileLoader.this.fileLoadRequest.isForceLoadFromNetwork()) {
                        this.publishProgress(new Integer[]{100});
                        loadedFile = AndroidFileManager.searchAndGetLocalFile(FileLoader.this.context, FileLoader.this.fileLoadRequest.getUri(), FileLoader.this.fileLoadRequest.getDirectoryName(), FileLoader.this.fileLoadRequest.getDirectoryType());
                    }
                    if (loadedFile == null || !loadedFile.exists() || FileLoader.this.fileLoadRequest.isAutoRefresh()) {
                        this.publishProgress(new Integer[]{101});
                        FileDownloader downloader = new FileDownloader(FileLoader.this.context, FileLoader.this.fileLoadRequest.getUri(), FileLoader.this.fileLoadRequest.getDirectoryName(), FileLoader.this.fileLoadRequest.getDirectoryType());
                        loadedFile = downloader.download(FileLoader.this.fileLoadRequest.isAutoRefresh(), FileLoader.this.fileLoadRequest.isCheckIntegrity());
                        this.publishProgress(new Integer[]{102});
                    }
                    downloadResponse.setDownloadedFile(loadedFile);
                }
                catch (Exception e) {
                    Log.d((String)FileLoader.TAG, (String)("doInBackground: " + e.getMessage()));
                    downloadResponse.setE(e);
                }
                return downloadResponse;
            }

            protected void onPostExecute(DownloadResponse downloadResponse) {
                super.onPostExecute((Object)downloadResponse);
                if (FileLoader.this.fileLoadRequest.getRequestListener() == null) {
                    return;
                }
                File downloadedFile = downloadResponse.getDownloadedFile();
                if (downloadedFile != null && downloadResponse.getE() == null) {
                    FileResponse fileResponse = FileLoader.this.createFileResponse(downloadedFile);
                    requestResponseMap.put(FileLoader.this.fileLoadRequest, fileResponse);
                    FileLoader.this.sendFileResponseToListeners(fileResponse);
                } else {
                    FileLoader.this.callFailureMethodsOfListeners(downloadResponse.getE());
                }
            }
        };
    }

    public FileLoadRequest getFileLoadRequest() {
        return this.fileLoadRequest;
    }

    public void setFileLoadRequest(FileLoadRequest fileLoadRequest) {
        this.fileLoadRequest = fileLoadRequest;
    }

    public FileDeleteRequest getFileDeleteRequest() {
        return this.fileDeleteRequest;
    }

    public void setFileDeleteRequest(FileDeleteRequest fileDeleteRequest) {
        this.fileDeleteRequest = fileDeleteRequest;
    }

    public static @interface DirectoryType {
    }
}

