/*
 * Decompiled with CFR 0.152.
 */
package com.krishna.fileloader.network;

import android.content.Context;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Log;
import com.krishna.fileloader.utility.AndroidFileManager;
import com.krishna.fileloader.utility.MD5;
import com.krishna.fileloader.utility.Utils;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;

public class FileDownloader {
    private static final String TAG = "FileDownloader";
    private String uri;
    private String dirName;
    private int dirType;
    private static OkHttpClient httpClient;
    private Context context;

    public FileDownloader(Context context, String uri, String dirName, int dirType) {
        this.context = context.getApplicationContext();
        this.uri = uri;
        this.dirName = dirName;
        this.dirType = dirType;
        this.initHttpClient();
    }

    private void initHttpClient() {
        if (httpClient == null) {
            HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
            interceptor.setLevel(HttpLoggingInterceptor.Level.NONE);
            httpClient = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).addInterceptor((Interceptor)interceptor).build();
        }
    }

    @WorkerThread
    public File download(boolean autoRefresh, boolean checkIntegrity) throws Exception {
        String eTag;
        String lastModifiedTime;
        Request.Builder requestBuilder = new Request.Builder().url(this.uri);
        File downloadFilePath = AndroidFileManager.getFileForRequest(this.context, this.uri, this.dirName, this.dirType);
        if (autoRefresh && (lastModifiedTime = Utils.getLastModifiedTime(downloadFilePath.lastModified())) != null) {
            requestBuilder.addHeader("If-Modified-Since", lastModifiedTime);
        }
        Request request = requestBuilder.build();
        Response response = httpClient.newCall(request).execute();
        if (autoRefresh && response.code() == 304) {
            return null;
        }
        if (!response.isSuccessful() || response.body() == null) {
            throw new IOException("Failed to download file: " + response);
        }
        if (downloadFilePath.exists() && downloadFilePath.delete()) {
            downloadFilePath = AndroidFileManager.getFileForRequest(this.context, this.uri, this.dirName, this.dirType);
        }
        BufferedSink sink = Okio.buffer((Sink)Okio.sink((File)downloadFilePath));
        long readBytes = sink.writeAll((Source)response.body().source());
        sink.close();
        int contentLength = 0;
        try {
            contentLength = Integer.parseInt(response.header("Content-Length", ""));
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        if (readBytes < (long)contentLength) {
            downloadFilePath.delete();
            Log.i((String)TAG, (String)("downloaded file is corrupt: " + request.url()));
            throw new IOException("Failed to download file: " + response);
        }
        if (checkIntegrity && !TextUtils.isEmpty((CharSequence)(eTag = response.header("ETag", "").replaceAll("\"", "").trim())) && !MD5.checkMD5(eTag, downloadFilePath)) {
            downloadFilePath.delete();
            Log.i((String)TAG, (String)("checksum did not match: " + request.url()));
            throw new IOException("Failed to download file: " + response);
        }
        long timeStamp = Utils.parseLastModifiedHeader(response.header("Last-Modified"));
        if (timeStamp > 0L) {
            downloadFilePath.setLastModified(timeStamp);
        }
        return downloadFilePath;
    }
}

