/*
 * Decompiled with CFR 0.152.
 */
package com.krishna.fileloader.network;

import android.content.Context;
import android.support.annotation.WorkerThread;
import com.krishna.fileloader.utility.AndroidFileManager;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;
import okio.Source;

public class FileDownloader {
    private String uri;
    private String dirName;
    private int dirType;
    private static OkHttpClient httpClient;
    private Context context;

    public FileDownloader(Context context, String uri, String dirName, int dirType) {
        this.context = context.getApplicationContext();
        this.uri = uri;
        this.dirName = dirName;
        this.dirType = dirType;
        this.initHttpClient();
    }

    private void initHttpClient() {
        if (httpClient == null) {
            HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
            interceptor.setLevel(HttpLoggingInterceptor.Level.NONE);
            httpClient = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).addInterceptor((Interceptor)interceptor).build();
        }
    }

    @WorkerThread
    public File download() throws Exception {
        Request request = new Request.Builder().url(this.uri).build();
        Response response = httpClient.newCall(request).execute();
        if (!response.isSuccessful() || response.body() == null) {
            throw new IOException("Failed to download file: " + response);
        }
        File downloadedFile = AndroidFileManager.getFileForRequest(this.context, this.uri, this.dirName, this.dirType);
        if (downloadedFile.exists() && downloadedFile.delete()) {
            downloadedFile = AndroidFileManager.getFileForRequest(this.context, this.uri, this.dirName, this.dirType);
        }
        BufferedSink sink = Okio.buffer((Sink)Okio.sink((File)downloadedFile));
        sink.writeAll((Source)response.body().source());
        sink.close();
        return downloadedFile;
    }
}

