/*
 * Decompiled with CFR 0.152.
 */
package com.krishna.fileloader;

import android.content.Context;
import android.os.AsyncTask;
import com.krishna.fileloader.listener.MultiFileDownloadListener;
import com.krishna.fileloader.network.FileDownloader;
import com.krishna.fileloader.request.MultiFileLoadRequest;
import com.krishna.fileloader.utility.AndroidFileManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class MultiFileDownloadTask
extends AsyncTask<MultiFileLoadRequest, Integer, Void> {
    private MultiFileDownloadListener listener;
    private Context context;
    private int totalTasks = 0;
    private int progress = 0;
    private List<File> downloadedFiles;
    private boolean forceLoadFromNetwork;

    public MultiFileDownloadTask(Context context, MultiFileDownloadListener listener, boolean forceLoadFromNetwork) {
        this.context = context.getApplicationContext();
        this.listener = listener;
        this.forceLoadFromNetwork = forceLoadFromNetwork;
        this.downloadedFiles = new ArrayList<File>();
    }

    protected Void doInBackground(MultiFileLoadRequest ... requests) {
        this.totalTasks = requests.length;
        for (MultiFileLoadRequest loadRequest : requests) {
            try {
                File downloadedFile = null;
                if (!this.forceLoadFromNetwork) {
                    downloadedFile = AndroidFileManager.searchAndGetLocalFile(this.context, loadRequest.getUri(), loadRequest.getDirectoryName(), loadRequest.getDirectoryType());
                }
                if (downloadedFile == null || !downloadedFile.exists()) {
                    FileDownloader downloader = new FileDownloader(this.context, loadRequest.getUri(), loadRequest.getDirectoryName(), loadRequest.getDirectoryType());
                    downloadedFile = downloader.download();
                }
                this.downloadedFiles.add(downloadedFile);
                this.publishProgress(new Integer[]{++this.progress});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected void onProgressUpdate(Integer ... values) {
        super.onProgressUpdate((Object[])values);
        if (this.listener != null) {
            try {
                this.listener.onProgress(this.downloadedFiles.get(values[0] - 1), values[0], this.totalTasks);
            }
            catch (Exception e) {
                try {
                    this.listener.onError(e, values[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

